<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class GarageDischarge extends Model
{

    use HasFactory;
    protected $fillable = [
        'customer_id',
        'policy_id',
        'claim_id',
        'garage_name',
        'discharge_date',
        'remarks',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function policy()
    {
        return $this->belongsTo(Policy::class);
    }

    public function claim()
    {
        return $this->belongsTo(Claim::class);
    }
}
