<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lead extends Model
{
    use SoftDeletes;

    protected $table = 'leads';

    protected $fillable = [
        'lead_type',
        'first_name',
        'middle_name',
        'last_name',
        'email',
        'phone',
        'company_name',
        'contact_person',
        'contact_phone',
        'contact_email',
        'industry',
        'notes',
        'source',
        'status',
        'priority',
        'last_contacted_at',
        'next_follow_up_at',
        'assigned_to',
        'customer_id',
        'corporate_customer_id',
    ];

    protected $dates = [
        'last_contacted_at',
        'next_follow_up_at',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    // In Lead.php

public function assignedUser()
{
    return $this->belongsTo(User::class, 'assigned_to');
}

public function customer()
{
    return $this->belongsTo(Customer::class);
}

public function activities()
{
    return $this->hasMany(LeadActivity::class);
}

}
