<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LeadActivity extends Model
{
    use SoftDeletes;

    protected $table = 'lead_activities';

    protected $fillable = [
        'lead_id',
        'activity_type',
        'description',
        'next_follow_up_at',
        'followed_up_at',
        'created_by',
    ];

    protected $dates = [
        'next_follow_up_at',
        'followed_up_at',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    // Relationships

    public function lead()
    {
        return $this->belongsTo(Lead::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
