<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NotificationJob extends Model
{
    protected $fillable = [
        'notification_id',
        'job_name',
        'status',
        'attempts',
        'scheduled_at',
        'started_at',
        'finished_at',
        'error_message',
    ];

    protected $casts = [
        'scheduled_at' => 'datetime',
        'started_at' => 'datetime',
        'finished_at' => 'datetime',
    ];

    public function notification(): BelongsTo
    {
        return $this->belongsTo(Notification::class);
    }

// Notification.php
public function customer()
{
    return $this->belongsTo(Customer::class, 'customer_id');
}


}
