<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class WorkOrder extends Model
{

    use HasFactory;
    protected $fillable = [
        'customer_id',
        'policy_id',
        'claim_id',
        'cob',
        'order_date',
        'garage_name',
        'customer_mobile',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function policy()
    {
        return $this->belongsTo(Policy::class);
    }

    public function claim()
    {
        return $this->belongsTo(Claim::class);
    }
}
