<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('work_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id')->constrained()->onDelete('cascade');
            $table->foreignId('policy_id')->constrained()->onDelete('cascade');
            $table->foreignId('claim_id')->constrained()->onDelete('cascade');
            $table->string('cob');
            $table->date('order_date')->nullable();
            $table->string('garage_name')->nullable();
            $table->string('customer_mobile')->nullable();
            $table->timestamps();
        });
            //
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
