<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('export_logs', function (Blueprint $table) {
            // Primary Key (int(11) NOT NULL)
            $table->increments('id'); // Auto-incrementing INTEGER
            
            // Foreign Key
            $table->foreignId('user_id') // BIGINT(20) UNSIGNED
                ->constrained()
                ->onDelete('cascade');

            // Export Details
            $table->string('file_name', 255);
            $table->enum('file_format', ['CSV', 'PDF', 'Excel']);

            // Timestamp
            $table->timestamp('exported_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('export_logs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('export_logs');
    }
};