<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('notification_templates', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('type'); // e.g., renewal, claim, survey
            $table->string('channel'); // sms, email, ivr
            $table->string('language', 10)->default('en'); // e.g., en, am, or
            $table->string('subject')->nullable(); // for email use
            $table->text('content'); // message body or IVR script
            $table->json('variables')->nullable(); // e.g., ["customer_name", "expiry_date"]
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->unique(['type', 'channel', 'language'], 'template_unique');
        });
    }

    public function down(): void {
        Schema::dropIfExists('notification_templates');
    }
};
