<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('notification_preferences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id')->constrained()->onDelete('cascade');

            $table->boolean('via_sms')->default(true);
            $table->boolean('via_email')->default(true);
            $table->boolean('via_ivr')->default(false);

            $table->string('language', 10)->default('en'); // override customer's default if needed

            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('notification_preferences');
    }
};
