@extends('layouts.master')


@section('title', 'Admin Dashboard')

@section('css')

    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />

     <link rel="stylesheet" type="text/css" href="{{ asset('assets/vendor/apexcharts/apexcharts.css') }}">



    <style>
        .progress-bar.productive {
            background-color: #28a745;
            /* SMS */
        }

        .progress-bar.middle {
            background-color: #007bff;
            /* Email */
        }

        .progress-bar.idle {
            background-color: #ffc107;
            /* IVR */
        }
    </style>


@endsection




@section('main_content')

    <div class="container-fluid mt-3">
        <div class="row">
            <div class="row">
                <!-- Notification Summary Cards Column -->
                <div class="col-lg-6 col-xxl-6">
                    <div class="row ">
                        <!-- Channel Usage Card -->
                        <div class="col-sm-6">
                            <div class="card project-total-card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h5 class="text-dark txt-ellipsis-1">Notification Channel</h5>
                                        <div class="clock-box">
                                            <div class="clock">
                                                <div class="hour" id="hour"></div>
                                                <div class="min" id="min"></div>
                                                <div class="sec" id="sec"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <h2 class="text-info-dark hour-display" id="totalNotifications">0</h2>

                                    <div class="progress-labels mg-t-40 d-flex justify-content-between">
                                        <span class="text-info" style="cursor: pointer;"
                                            onclick="loadChannelData('sms')">SMS</span>
                                        <span class="text-info" style="cursor: pointer;"
                                            onclick="loadChannelData('email')">Email</span>
                                        <span class="text-info" style="cursor: pointer;"
                                            onclick="loadChannelData('ivr')">IVR</span>
                                    </div>

                                    <div class="custom-progress-container info-progress mt-3">
                                        <div class="progress-bar productive" style="width: 40%; background-color: #0dcaf0;">
                                        </div>
                                        <div class="progress-bar middle" style="width: 35%; background-color: #198754;">
                                        </div>
                                        <div class="progress-bar idle" style="width: 25%; background-color: #ffc107;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- Pending Notifications Card -->
                        <div class="col-sm-6">
                            <div class="card bg-warning-300 project-details-card">
                                <div class="card-body">
                                    <div class="d-flex gap-2 mb-2">
                                        <span class="badge bg-white-300 text-warning-dark p-1 b-r-10">⏳ Pending</span>
                                        <span
                                            class="badge dashed-1-warning text-warning-dark ms-2 p-1 b-r-10">Notifications</span>
                                    </div>
                                    <h5 class="f-w-600 text-warning-dark txt-ellipsis-1">Pending Notifications</h5>
                                    <p class="text-warning f-s-13 txt-ellipsis-1 mb-3">Notifications queued for sending.</p>
                                    <h2 id="pendingCount" class="text-warning-dark">0</h2>
                                </div>
                            </div>
                        </div>

                        <!-- Failed Notifications Card -->
                        <div class="col-sm-6">
                            <div class="card bg-danger-300 project-details-card">
                                <div class="card-body">
                                    <div class="d-flex gap-2 mb-2">
                                        <span class="badge bg-white-300 text-danger-dark p-1 b-r-10">❌ Failed</span>
                                        <span
                                            class="badge dashed-1-danger text-danger-dark ms-2 p-1 b-r-10">Notifications</span>
                                    </div>
                                    <h5 class="f-w-600 text-danger-dark txt-ellipsis-1">Failed Notifications</h5>
                                    <p class="text-danger f-s-13 txt-ellipsis-1 mb-3">Notifications that failed to send.</p>
                                    <h2 id="failedCount" class="text-danger-dark">0</h2>
                                </div>
                            </div>
                        </div>

                        <!-- Completed Notifications Card -->
                        <div class="col-sm-6">
                            <div class="card bg-success-300 project-details-card">
                                <div class="card-body">
                                    <div class="d-flex gap-2 mb-2">
                                        <span class="badge bg-white-300 text-success-dark p-1 b-r-10">✅ Completed</span>
                                        <span
                                            class="badge dashed-1-success text-success-dark ms-2 p-1 b-r-10">Notifications</span>
                                    </div>
                                    <h5 class="f-w-600 text-success-dark txt-ellipsis-1">Completed Notifications</h5>
                                    <p class="text-success f-s-13 txt-ellipsis-1 mb-3">Successfully sent notifications.</p>
                                    <h2 id="completedCount" class="text-success-dark">0</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Tracker Column -->
                <div class="col-lg-6 col-xxl-6 order-1-md">
                    <div class="p-3">
                        <h5>Notification Jobs Tracker</h5>
                    </div>

                    <div class="card">
                        <div class="card-body position-relative">
                            <div class="time-tracker">
                                <h2 class="timer-display f-w-600" id="jobTimer">00:00:00</h2>

                                <div class="controls mb-3">
                                    <button class="btn btn-light-primary icon-btn b-r-18" id="play-btn">
                                        <i class="iconoir-play-solid"></i>
                                    </button>
                                    <button class="btn btn-danger icon-btn b-r-18" id="pause-btn" disabled>
                                        <i class="iconoir-square"></i>
                                    </button>
                                    <button class="btn btn-light-info icon-btn b-r-18" id="reset-btn">
                                        <i class="iconoir-refresh"></i>
                                    </button>
                                </div>
                            </div>

                            <ul class="tracker-history-list app-scroll mt-3" style="max-height: 300px; overflow-y: auto;">
                                <!-- Job records injected via JS -->
                            </ul>
                        </div>
                    </div>
                </div>

            </div>
        </div>
<div class="row">

<div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h5> Notification Chart</h5>
                    </div>
                    <div class="card-body">
                        <div id="mixed4"></div>
                    </div>
                </div>
            </div>

        </div>

    </div>

    <!-- Notification Channel Modal -->
    <!-- Channel Breakdown Modal -->
    <div class="modal fade" id="channelModal" tabindex="-1" aria-labelledby="channelModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="channelModalLabel">Channel Breakdown</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <select class="form-select" id="channelStatusFilter">
                                <option value="">All Statuses</option>
                                <option value="pending">Pending</option>
                                <option value="sent">Sent</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <input type="text" class="form-control" id="channelSearchInput"
                                placeholder="Search message or title">
                        </div>
                        <div class="col-md-4 text-end">
                            <button class="btn btn-sm btn-outline-primary" id="exportBtn">Export</button>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Message</th>
                                    <th>Channel</th>
                                    <th>Status</th>
                                    <th>Scheduled At</th>
                                    <th>Created At</th>
                                </tr>
                            </thead>
                            <tbody id="channelTableBody"></tbody>
                        </table>
                    </div>
                    <nav>
                        <ul class="pagination justify-content-center" id="channelPagination"></ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <div class="modal" data-bs-backdrop="static" id="welcomeCard" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content welcome-card">

                <div class="modal-body p-0">
                    <div class="text-center position-relative welcome-card-content z-1 p-3">
                        <div class="text-end position-relative z-1">
                            <i class="ti ti-x fs-5 text-dark f-w-600" data-bs-dismiss="modal"></i>
                        </div>
                        <h2 class="f-w-700 text-primary-dark mb-0"><span>Welcome!</span> <img alt="gif"
                                class="w-45 d-inline align-baseline"
                                src="{{ asset('assets/images/dashboard/ecommerce-dashboard/celebration.gif') }}">
                        </h2>

                        <div class="modal-img-box">
                            <img alt="img" class=" img-fluid" src="{{ asset('assets/images/modals/welcome-1.png') }}">
                        </div>
                        <div class="modal-btn mb-4">
                            <button class="btn btn-primary text-white btn-sm rounded" data-bs-dismiss="modal" type="button">
                                Get Started
                            </button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

@endsection




@section('scripts')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="{{ asset('assets/vendor/apexcharts/apexcharts.min.js') }}"></script>

    <script src="{{ asset('assets/js/mixed.js') }}"></script>

<!-- js-->
<script src="assets/js/mixed.js"></script>

    <script>
        // Make sure this is in global scope
        function loadChannelData(channel, page = 1) {
            // Get modal instance
            const modalEl = document.getElementById('channelModal');
            const modal = bootstrap.Modal.getOrCreateInstance(modalEl);

            // Update modal title
            document.getElementById('channelModalLabel').textContent = `Channel Breakdown: ${channel.toUpperCase()}`;

            // Store current channel for filter/search usage
            window.currentChannel = channel;

            // Prepare fetch URL and params (default no filter/search for initial load)
            const params = new URLSearchParams({
                channel: channel,
                page: page,
                status: document.getElementById('channelStatusFilter').value || '',
                search: document.getElementById('channelSearchInput').value.trim() || '',
            });

            fetch(`{{ route('admin.notifications.channel-data') }}?${params.toString()}`)
                .then(res => res.json())
                .then(data => {
                    // Fill table body
                    document.getElementById('channelTableBody').innerHTML = data.tableRows;
                    // Fill pagination
                    document.getElementById('channelPagination').innerHTML = data.pagination;

                    // Add click to pagination links
                    document.querySelectorAll('#channelPagination a.page-link').forEach(link => {
                        link.addEventListener('click', e => {
                            e.preventDefault();
                            const pageNum = link.getAttribute('data-page');
                            if (pageNum) loadChannelData(channel, pageNum);
                        });
                    });

                    // Show modal
                    modal.show();
                })
                .catch(err => console.error(err));
        }
        document.addEventListener('DOMContentLoaded', () => {
            const modal = new bootstrap.Modal(document.getElementById('channelModal'));
            const modalTitle = document.getElementById('channelModalLabel');
            const statusFilter = document.getElementById('channelStatusFilter');
            const searchInput = document.getElementById('channelSearchInput');
            const exportBtn = document.getElementById('exportBtn');
            const tableBody = document.getElementById('channelTableBody');
            const pagination = document.getElementById('channelPagination');

            const smsBarWrapper = document.getElementById('smsBarWrapper');
            const emailBarWrapper = document.getElementById('emailBarWrapper');
            const ivrBarWrapper = document.getElementById('ivrBarWrapper');

            const smsCount = document.getElementById('smsCount');
            const emailCount = document.getElementById('emailCount');
            const ivrCount = document.getElementById('ivrCount');

            let currentChannel = null;
            let currentPage = 1;
            let searchTimeout = null;

            // Load chart/summary stats
            function loadNotificationStats() {
                fetch("{{ route('admin.dashboard.notification-stats') }}")
                    .then(res => res.json())
                    .then(data => {
                        const smsTotal = data.sms.total || 0;
                        const emailTotal = data.email.total || 0;
                        const ivrTotal = data.ivr.total || 0;
                        const total = smsTotal + emailTotal + ivrTotal || 1;

                        smsBarWrapper.style.width = (smsTotal / total * 100) + '%';
                        emailBarWrapper.style.width = (emailTotal / total * 100) + '%';
                        ivrBarWrapper.style.width = (ivrTotal / total * 100) + '%';

                        smsCount.textContent = `SMS (${smsTotal})`;
                        emailCount.textContent = `Email (${emailTotal})`;
                        ivrCount.textContent = `IVR (${ivrTotal})`;
                    });
            }

            // Load modal table data
            function loadChannelTable(channel, page = 1) {
                currentChannel = channel;
                currentPage = page;
                modalTitle.textContent = `Channel Breakdown: ${channel.toUpperCase()}`;

                const status = statusFilter.value;
                const search = searchInput.value.trim();

                const params = new URLSearchParams({
                    channel,
                    status,
                    search,
                    page
                });

                fetch(`{{ route('admin.notifications.channel-data') }}?${params.toString()}`)
                    .then(res => res.json())
                    .then(data => {
                        tableBody.innerHTML = data.tableRows || '<tr><td colspan="6" class="text-center">No results found</td></tr>';
                        pagination.innerHTML = data.pagination || '';

                        // Attach pagination click handlers
                        document.querySelectorAll('#channelPagination a.page-link').forEach(link => {
                            link.addEventListener('click', (e) => {
                                e.preventDefault();
                                const pageNum = link.getAttribute('data-page');
                                if (pageNum) loadChannelTable(channel, parseInt(pageNum));
                            });
                        });
                    });

                modal.show();
            }

            // Debounced search handler
            searchInput.addEventListener('input', () => {
                clearTimeout(searchTimeout);
                searchTimeout = setTimeout(() => {
                    if (currentChannel) loadChannelTable(currentChannel, 1);
                }, 300);
            });

            // Filter change handler
            statusFilter.addEventListener('change', () => {
                if (currentChannel) loadChannelTable(currentChannel, 1);
            });

            // Export button
            exportBtn.addEventListener('click', () => {
                if (!currentChannel) return alert('Please open a channel first.');

                const params = new URLSearchParams({
                    channel: currentChannel,
                    status: statusFilter.value,
                    search: searchInput.value.trim()
                });

                window.open(`{{ route('admin.notifications.export') }}?${params.toString()}`, '_blank');
            });

            // Bar click bindings
            smsBarWrapper.addEventListener('click', () => loadChannelTable('sms'));
            emailBarWrapper.addEventListener('click', () => loadChannelTable('email'));
            ivrBarWrapper.addEventListener('click', () => loadChannelTable('ivr'));

            loadNotificationStats();
            setInterval(loadNotificationStats, 60000);
        });






    </script>

    <script>
        let jobTimerInterval = null;
        let jobElapsedSeconds = 0;
        let jobTimerRunning = false;
        let jobRefreshInterval = null;

        function formatJobTime(seconds) {
            const h = String(Math.floor(seconds / 3600)).padStart(2, '0');
            const m = String(Math.floor((seconds % 3600) / 60)).padStart(2, '0');
            const s = String(seconds % 60).padStart(2, '0');
            return `${h}:${m}:${s}`;
        }

        function updateJobTimerDisplay() {
            document.getElementById('jobTimer').innerText = formatJobTime(jobElapsedSeconds);
        }

        function startJobTimer() {
            if (jobTimerRunning) return;
            jobTimerRunning = true;

            toastr.success('Job tracking started', 'Started');

            $('#play-btn').prop('disabled', true);
            $('#pause-btn').prop('disabled', false);

            jobTimerInterval = setInterval(() => {
                jobElapsedSeconds++;
                updateJobTimerDisplay();
            }, 1000);

            loadNotificationJobs(); // initial load
            jobRefreshInterval = setInterval(loadNotificationJobs, 5000);
        }

        function stopJobTimer() {
            if (!jobTimerRunning) return;
            jobTimerRunning = false;

            toastr.warning('Job tracking paused', 'Paused');

            $('#play-btn').prop('disabled', false);
            $('#pause-btn').prop('disabled', true);

            clearInterval(jobTimerInterval);
            clearInterval(jobRefreshInterval);
        }

        function resetJobTimer() {
            toastr.info('Tracker reset', 'Reset');
            jobElapsedSeconds = 0;
            updateJobTimerDisplay();
            stopJobTimer();
            $('.tracker-history-list').empty();
        }

        const jobBgClasses = ['bg-primary-300', 'bg-success-300', 'bg-info-300', 'bg-warning-300', 'bg-danger-300', 'bg-secondary-300'];

        function getRandomJobBgClass() {
            return jobBgClasses[Math.floor(Math.random() * jobBgClasses.length)];
        }

        function loadNotificationJobs() {
            $.ajax({
                url: '/admin/notification-jobs/recent',
                method: 'GET',
                dataType: 'json',
                success: function (data) {
                    const list = $('.tracker-history-list');
                    list.empty();

                    if (!data || data.length === 0) {
                        list.append('<li class="bg-light p-2">No jobs found.</li>');
                        return;
                    }

                    data.sort((a, b) => new Date(b.scheduled_at) - new Date(a.scheduled_at)); // Newest first

                    data.forEach(function (job, index) {
                        const $item = $(`
        <li class="${getRandomJobBgClass()} d-flex gap-2 flex-wrap p-3 mb-3 rounded shadow-sm animate__animated animate__fadeInUp"
            data-slick-index="${index}" aria-hidden="false" style="display:none;">

          <div class="d-flex align-items-center justify-content-between mb-2">
            <h6 class="f-w-600 mb-0 text-dark">🔔 #${job.id}</h6>
            <span class="badge bg-dark text-light text-uppercase">${job.status}</span>
          </div>

          <div class="mb-2">
            <p class="mb-0 text-dark txt-ellipsis-2">
              <i class="iconoir-user-circle me-1 text-secondary"></i>
              <strong>${job.customer_name}</strong> — ${job.title}
            </p>
          </div>

          <div class="text-muted f-s-12">
            <i class="iconoir-calendar me-1"></i>
            Scheduled: ${job.scheduled_at}
          </div>
        </li>
      `);

                        $('.tracker-history-list').append($item);
                        $item.slideDown(400);
                    });


                },
                error: function () {
                    $('.tracker-history-list').html('<li class="bg-danger-300 p-2 text-white">Error loading jobs</li>');
                }
            });
        }

        $(document).ready(function () {
            $('#play-btn').on('click', startJobTimer);
            $('#pause-btn').on('click', stopJobTimer);
            $('#reset-btn').on('click', resetJobTimer);

            startJobTimer();
        });


        function updateClock() {
            const now = new Date();
            const hour = now.getHours();
            const minutes = now.getMinutes();
            const seconds = now.getSeconds();

            const hourHand = document.getElementById("hour");
            const minuteHand = document.getElementById("min");
            const secondHand = document.getElementById("sec");
            const hourDisplay = document.querySelector(".hour-display");
            // const minDisplay = document.querySelector(".min-display");

            hourDisplay.textContent = `${hour}H`;
            // minDisplay.textContent = `${minutes}M`;

            const hourDeg = (hour % 12) * 30 + minutes * 0.5;
            const minuteDeg = minutes * 6;
            const secondDeg = seconds * 6;

            hourHand.style.transform = `translate(-50%, -100%) rotate(${hourDeg}deg)`;
            minuteHand.style.transform = `translate(-50%, -100%) rotate(${minuteDeg}deg)`;
            secondHand.style.transform = `translate(-50%, -100%) rotate(${secondDeg}deg)`;
        }

        // Update clock every second
        setInterval(updateClock, 1000);
        updateClock();

    </script>

































@endsection
