@extends('layouts.master')

@section('title', 'Input Mask')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Input Mask</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Form Controls</li>
                <li class="breadcrumb-item f-w-400 active">Input Mask</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Input masks</h4>
                        <p class="f-m-light mt-1">
                            Input mask used in form-validations,forms,card-details,and etc.</p>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-sm-6">
                                <div class="card-wrapper border rounded-3 light-card checkbox-checked">
                                    <h6 class="sub-title">Date Format</h6>
                                    <form class="row g-3">
                                        <div class="col-12">
                                            <label class="col-form-label" for="cleave-date1">Date</label>
                                            <input class="form-control" id="cleave-date1" type="text"
                                                placeholder="DD-MM-YYYY">
                                        </div>
                                        <div class="col-12">
                                            <label class="col-form-label" for="cleave-date2">Date format type</label>
                                            <input class="form-control" id="cleave-date2" type="text"
                                                placeholder="MM-YYYY">
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="card-wrapper border rounded-3 light-card checkbox-checked">
                                    <h6 class="sub-title">Time Format</h6>
                                    <form class="row g-3">
                                        <div class="col-12">
                                            <label class="col-form-label" for="cleave-time1">Time format type</label>
                                            <input class="form-control" id="cleave-time1" type="text"
                                                placeholder="hh:mm:ss">
                                        </div>
                                        <div class="col-12">
                                            <label class="col-form-label" for="cleave-time2">Hour/month type</label>
                                            <input class="form-control" id="cleave-time2" type="text"
                                                placeholder="hh:mm">
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="card-wrapper border rounded-3 light-card checkbox-checked">
                                    <h6 class="sub-title">Default Input Mask</h6>
                                    <form class="row g-3">
                                        <div class="col-xxl-4 col-sm-6">
                                            <label class="col-form-label" for="cleave-number-format">Currency</label>
                                            <input class="form-control" id="cleave-number-format" type="text"
                                                placeholder="Enter number">
                                        </div>
                                        <div class="col-xxl-4 col-sm-6">
                                            <label class="col-form-label" for="cleave-type-prefix">Prefix</label>
                                            <input class="form-control" id="cleave-type-prefix" type="text"
                                                placeholder="Prefix-xxxx-xxxx-xxxx">
                                        </div>
                                        <div class="col-xxl-4 col-sm-6">
                                            <label class="col-form-label" for="cleave-type-delimiter">Delimiter</label>
                                            <input class="form-control" id="cleave-type-delimiter" type="text"
                                                placeholder="xxx·xxx·xxx">
                                        </div>
                                        <div class="col-xxl-4 col-sm-6">
                                            <label class="form-label" for="cleave-phone-number">Phone Number</label>
                                            <input class="form-control" id="cleave-phone-number" type="text"
                                                placeholder="(xxx)xxx-xxxx">
                                        </div>
                                        <div class="col-xxl-4 col-sm-6">
                                            <label class="form-label" for="cleave-card-number">Card Number</label>
                                            <input class="form-control" id="cleave-card-number" type="text"
                                                placeholder="xxxx xxxx xxxx xxxx">
                                        </div>
                                        <div class="col-xxl-4 col-sm-6">
                                            <label class="form-label" for="tailprefix">Tailprefix</label>
                                            <input class="form-control" id="tailprefix" type="text"
                                                placeholder="0000.00€">
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <!-- calendar js-->
    <script src="{{ asset('assets/js/cleave/cleave.min.js') }}"></script>
    <script src="{{ asset('assets/js/cleave/custom-cleave.js') }}"></script>
    <script src="{{ asset('assets/js/height-equal.js') }}"></script>
@endsection
