@extends('layouts.master')

@section('title', 'Knowledgebase')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Knowledgebase</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Knowledgebase</li>
                <li class="breadcrumb-item f-w-400 active">Knowledgebase</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="knowledgebase-bg"><img class="bg-img-cover bg-center"
                        src="{{ asset('assets/images/knowledgebase/bg_1.jpg') }}" alt="looginpage"></div>
                <div class="knowledgebase-search">
                    <div>
                        <h3 class="f-w-500">How Can I help you?</h3>
                        <form class="form-inline" action="#" method="get">
                            <div class="form-group w-100"><i data-feather="search"></i>
                                <input class="form-control-plaintext w-100" type="text" placeholder="Type question here"
                                    title="">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-sm-6">
                <div class="card bg-primary">
                    <div class="card-body">
                        <div class="d-flex faq-widgets">
                            <div class="flex-grow-1">
                                <h4>Articles</h4>
                                <p>How little experience or technical knowledge you currently have. The web is a very big
                                    place, and if you are the typical internet user, you probably visit several websites
                                    every day.</p>
                            </div><i data-feather="book-open"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-sm-6">
                <div class="card bg-primary">
                    <div class="card-body">
                        <div class="d-flex faq-widgets">
                            <div class="flex-grow-1">
                                <h4>Knowledgebase</h4>
                                <p>A Website Designing course enables learners to use essential designing and programming
                                    tools copy required to do the job. The curriculum is a blend of various themes.</p>
                            </div><i data-feather="aperture"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4">
                <div class="card bg-primary">
                    <div class="card-body">
                        <div class="d-flex faq-widgets">
                            <div class="flex-grow-1">
                                <h4>Support</h4>
                                <p>The customer support industry is renaissance. Customer support as a specialty is coming
                                    into its own, offering companies a competitive advantage that’s difficult to copy.</p>
                            </div><i data-feather="file-text"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="header-faq">
                    <h4 class="mb-0">Browse articles by category</h4>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card">
                            <div class="card-header card-no-border pb-0">
                                <h4>Browse Articles</h4>
                            </div>
                            <div class="card-body">
                                <div class="row browse g-sm-4 g-3">
                                    <div class="col-xl-4 xl-50 col-md-6">
                                        <div class="browse-articles">
                                            <h5><span><i data-feather="archive"></i></span>Quick Questions are answered</h5>
                                            <ul>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Policies have wide
                                                            acceptance editors.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Guidelines are
                                                            sets of best practices supported.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Editors should
                                                            attempt to follow guidelines. </span><span
                                                            class="badge badge-primary pull-right">New</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>They are best
                                                            treated with common sense. </span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="arrow-right"></i></span><span>See More
                                                            (40)</span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 xl-50 col-md-6">
                                        <div class="browse-articles">
                                            <h5><span><i data-feather="archive"></i></span> API allows search and download
                                                AP Images.</h5>
                                            <ul>
                                                <li><a href="#"><span><i data-feather="file-text"></i></span><span>API
                                                            retrieve breaking news categories.</span><span
                                                            class="badge badge-primary pull-right">Review</span></a></li>
                                                <li><a href="#"><span><i data-feather="file-text"></i></span><span>API
                                                            retrieves rules for fantasy league.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Resource API
                                                            retrieves content produced business.</span><span
                                                            class="badge badge-primary pull-right">Articles</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Making this the
                                                            first true generator on the Internet.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="arrow-right"></i></span><span>See More
                                                            (90)</span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 xl-50 col-md-6">
                                        <div class="browse-articles">
                                            <h5><span><i data-feather="archive"></i></span>WordPress Site Maintenance</h5>
                                            <ul>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Make a backup of
                                                            your WordPress website.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Run
                                                            a Wordpress security Website check.</span><span
                                                            class="badge badge-primary pull-right">Closed</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Monitor your
                                                            search engine optimization.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Set
                                                            a regular maintenance schedule.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="arrow-right"></i></span><span>See More
                                                            (50)</span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 xl-50 col-md-6">
                                        <div class="browse-articles browse-bottom">
                                            <h5><span><i data-feather="archive"></i> Meta Tags in WordPress</span></h5>
                                            <ul>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>When an unknown
                                                            printer took a galley</span><span
                                                            class="badge badge-primary pull-right">Popular</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>You can easily
                                                            change plans at any time.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>you’ll be charged
                                                            a prorated cover that upgrade.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>But also the leap
                                                            into electronic typesetting,</span></a><a
                                                        href="#"><span><i
                                                                data-feather="arrow-right"></i></span><span>See More
                                                            (90)</span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 xl-50 col-md-6">
                                        <div class="browse-articles browse-bottom">
                                            <h5><span><i data-feather="archive"></i></span>WordPress in Your Language</h5>
                                            <ul>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Premium plans are
                                                            billed as a single yearly payment.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Monthly plan are
                                                            bill every month of signup.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>You can set
                                                            Monthly or Yearly for Premium plan.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>unknown printer
                                                            took galley.</span><span
                                                            class="badge badge-primary pull-right">Closed</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="arrow-right"></i></span><span>See More
                                                            (50)</span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 xl-50 col-md-6">
                                        <div class="browse-articles browse-bottom">
                                            <h5><span><i data-feather="archive"></i></span>Know Your Sources</h5>
                                            <ul>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Many new editors
                                                            rely on policy interpretations.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Editor
                                                            continually attempts to find a different policy.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Violation of
                                                            maintaining a neutral point of view.</span><span
                                                            class="badge badge-primary pull-right">Article</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>You double check
                                                            your sources.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="arrow-right"></i></span><span>See More
                                                            (26)</span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 xl-50 col-md-6">
                                        <div class="browse-articles browse-bottom">
                                            <h5><span><i data-feather="archive"></i></span>Validating a Website</h5>
                                            <ul>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>You can modify
                                                            some specific component settings.</span><span
                                                            class="badge badge-primary pull-right">Review</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Click Apply to
                                                            validate the set preferences. </span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Following
                                                            procedure apply the components</span><span
                                                            class="badge badge-primary pull-right">Closed</span></a></li>
                                                <li><a href="#"><span><i data-feather="file-text"></i></span><span>
                                                            To modify those specific components settings.</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="arrow-right"></i></span><span>See More
                                                            (10)</span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 xl-50 col-md-6">
                                        <div class="browse-articles browse-bottom">
                                            <h5><span><i data-feather="archive"></i></span>Quick Questions are answered
                                            </h5>
                                            <ul>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>To get started
                                                            with your account. </span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Compile your
                                                            theme using gulp</span><span
                                                            class="badge badge-primary pull-right">Popular</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Users can browse
                                                            by topic or use the visually.</span><span
                                                            class="badge badge-primary pull-right">Review</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>This works
                                                            through various methods of site tracking</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="arrow-right"></i></span><span>See More
                                                            (21)</span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="col-xl-4 xl-100">
                                        <div class="browse-articles browse-bottom">
                                            <h5><span><i data-feather="archive"></i></span>Integrating WordPress with Your
                                                Website</h5>
                                            <ul>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>The core of your
                                                            online presence is your website</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Your website is a
                                                            24/7 marketing tool </span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>Build a website
                                                            that turns users into buyers</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="file-text"></i></span><span>User experience
                                                            determines a website's success</span><span
                                                            class="badge badge-primary pull-right">On hold</span></a></li>
                                                <li><a href="#"><span><i
                                                                data-feather="arrow-right"></i></span><span>See More
                                                            (34)</span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="header-faq">
                    <h4 class="mb-0">Featured Tutorials</h4>
                </div>
                <div class="row">
                    <div class="col-xl-3 xl-50 col-md-6 box-col-6">
                        <div class="card features-faq product-box">
                            <div class="faq-image product-img"><img class="img-fluid"
                                    src="{{ asset('assets/images/faq/1.jpg') }}" alt="">
                                <div class="product-hover">
                                    <ul>
                                        <li><i class="icon-link"></i></li>
                                        <li><i class="icon-import"></i></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <h5 class="f-w-600"> Web Design</h5>
                                <p>Web designing course belongs to the field of computer science and IT. It enables students
                                    to learn.</p>
                            </div>
                            <div class="card-footer"><span>Dec 15, 2024</span><span class="pull-right"><i
                                        class="fa fa-star font-primary"></i><i class="fa fa-star font-primary"></i><i
                                        class="fa fa-star font-primary"></i><i class="fa fa-star font-primary"></i><i
                                        class="fa fa-star font-primary"></i></span></div>
                        </div>
                    </div>
                    <div class="col-xl-3 xl-50 col-md-6 box-col-6">
                        <div class="card features-faq product-box">
                            <div class="faq-image product-img"><img class="img-fluid"
                                    src="{{ asset('assets/images/faq/2.jpg') }}" alt="">
                                <div class="product-hover">
                                    <ul>
                                        <li><i class="icon-link"></i></li>
                                        <li><i class="icon-import"></i></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <h5 class="f-w-600">Web Development</h5>
                                <p>This course is designed to start you on a path toward future studies in web development
                                    and design.</p>
                            </div>
                            <div class="card-footer"><span>Dec 15, 2024</span><span class="pull-right"><i
                                        class="fa fa-star font-primary"></i><i class="fa fa-star font-primary"></i><i
                                        class="fa fa-star font-primary"></i><i class="fa fa-star font-primary"></i><i
                                        class="fa fa-star-o font-primary"></i></span></div>
                        </div>
                    </div>
                    <div class="col-xl-3 xl-50 col-md-6 box-col-6">
                        <div class="card features-faq product-box">
                            <div class="faq-image product-img"><img class="img-fluid"
                                    src="{{ asset('assets/images/faq/3.jpg') }}" alt="">
                                <div class="product-hover">
                                    <ul>
                                        <li><i class="icon-link"></i></li>
                                        <li><i class="icon-import"></i></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <h5 class="f-w-600">UI Design</h5>
                                <p>User interface design (UI) is the design for machines and software, such as mobile
                                    devices, computers.</p>
                            </div>
                            <div class="card-footer"><span>Dec 15, 2024</span><span class="pull-right"><i
                                        class="fa fa-star font-primary"></i><i class="fa fa-star font-primary"></i><i
                                        class="fa fa-star font-primary"></i><i class="fa fa-star font-primary"></i><i
                                        class="fa fa-star font-primary"></i></span></div>
                        </div>
                    </div>
                    <div class="col-xl-3 xl-50 col-md-6 box-col-6">
                        <div class="card features-faq product-box">
                            <div class="faq-image product-img"><img class="img-fluid"
                                    src="{{ asset('assets/images/faq/4.jpg') }}" alt="">
                                <div class="product-hover">
                                    <ul>
                                        <li><i class="icon-link"></i></li>
                                        <li><i class="icon-import"></i></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="card-body">
                                <h5 class="f-w-600">UX Design</h5>
                                <p>Web designing course belongs to the field of computer science and IT. It enables students
                                    to learn.</p>
                            </div>
                            <div class="card-footer"><span>Dec 15, 2024</span><span class="pull-right"><i
                                        class="fa fa-star font-primary"></i><i class="fa fa-star font-primary"></i><i
                                        class="fa fa-star font-primary"></i><i class="fa fa-star font-primary"></i><i
                                        class="fa fa-star-half-o font-primary"></i></span></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="header-faq">
                    <h4 class="mb-0">Latest articles and videos</h4>
                </div>
                <div class="row">
                    <div class="col-xl-4 col-md-6">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex articles-icons"><i class="m-r-20" data-feather="codepen"></i>
                                            <div class="flex-grow-1">
                                                <h5 class="f-w-600">Product manager</h5>
                                                <p>A product manager is a specialist in charge of managing the growth,
                                                    direction.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex articles-icons"><i class="m-r-20" data-feather="codepen"></i>
                                            <div class="flex-grow-1">
                                                <h5 class="f-w-600">E-commerce</h5>
                                                <p>Discover the flourishing e-commerce industry and how digital technology
                                                    has transformed it.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex articles-icons"><i class="m-r-20" data-feather="codepen"></i>
                                            <div class="flex-grow-1">
                                                <h5 class="f-w-600">Web-development</h5>
                                                <p>To display HTML and CSS components on different web browsers, such as
                                                    Chrome, Safari.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-md-6">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex articles-icons"><i class="m-r-20"
                                                data-feather="file-text"></i>
                                            <div class="flex-grow-1">
                                                <h5 class="f-w-600">UX designer</h5>
                                                <p>Seniority does have a significant role in how much influence a UI
                                                    specialist.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex articles-icons"><i class="m-r-20"
                                                data-feather="file-text"></i>
                                            <div class="flex-grow-1">
                                                <h5 class="f-w-600">SDLC cycle</h5>
                                                <p>The intricacies of Software Development Life Cycle a systematic approach
                                                    to software development.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex articles-icons"><i class="m-r-20"
                                                data-feather="file-text"></i>
                                            <div class="flex-grow-1">
                                                <h5 class="f-w-600">Using Video </h5>
                                                <p>Information architecture is a discipline that, among other things,
                                                    arranges, and structures.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="row">
                            <div class="col-xl-12 col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex articles-icons"><i class="m-r-20" data-feather="youtube"></i>
                                            <div class="flex-grow-1">
                                                <h5 class="f-w-600">Information gathering</h5>
                                                <p>Explore the critical role of information gathering in effective
                                                    problem-solving processes.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-12 col-md-6">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex articles-icons"><i class="m-r-20" data-feather="youtube"></i>
                                            <div class="flex-grow-1">
                                                <h5 class="f-w-600">Effective communication</h5>
                                                <p>It's crucial communicate! This blog explores the key components of good
                                                    communication.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex articles-icons"><i class="m-r-20" data-feather="youtube"></i>
                                            <div class="flex-grow-1">
                                                <h5 class="f-w-600">Travel adventures</h5>
                                                <p>The spirit is enriched by travel! This site takes you on an exhilarating
                                                    tour of stunning.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')

@endsection
