<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Notification extends Model
{
    protected $fillable = [
        'customer_id',
        'policy_id',
        'channel',
        'type',
        'payload',
        'status',
        'scheduled_at',
        'sent_at',
        'error_message',
    ];

    protected $casts = [
        'payload' => 'array',
        'scheduled_at' => 'datetime',
        'sent_at' => 'datetime',
    ];




    public function policy(): BelongsTo
    {
        return $this->belongsTo(Policy::class);
    }

    public function logs(): HasMany
    {
        return $this->hasMany(NotificationLog::class);
    }

    public function jobs(): HasMany
    {
        return $this->hasMany(NotificationJob::class);
    }



    public function claim() {
        return $this->belongsTo(Claim::class, 'claim_id');
    }



    public function surveyStatus() {
        return $this->hasOne(SurveyStatus::class, 'customer_id', 'customer_id');
    }

    public function garageDischarge() {
        return $this->hasOne(GarageDischarge::class, 'customer_id', 'customer_id');
    }

    public function customer()
{
    return $this->belongsTo(Customer::class);
}

public function claims()
{
    return $this->hasMany(Claim::class, 'customer_id', 'customer_id');
}

public function policies()
{
    return $this->hasMany(Policy::class, 'customer_id', 'customer_id');
}

public function claimPayments()
{
    return $this->hasMany(ClaimPayment::class, 'customer_id', 'customer_id');
}

public function garageDischarges()
{
    return $this->hasMany(GarageDischarge::class, 'customer_id', 'customer_id');
}

public function surveyStatuses()
{
    return $this->hasMany(SurveyStatus::class, 'customer_id', 'customer_id');
}

public function workOrders()
{
    return $this->hasMany(WorkOrder::class, 'customer_id', 'customer_id');
}
}
