<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

use App\Models\Policy;
use App\Models\Claim;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\GarageDischarge>
 */
class GarageDischargeFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $policy = Policy::inRandomOrder()->first() ?? Policy::factory()->create();
        $claim = Claim::where('policy_id', $policy->id)->inRandomOrder()->first()
                 ?? Claim::factory()->create([
                     'policy_id' => $policy->id,
                     'customer_id' => $policy->customer_id,
                 ]);

        return [
            'customer_id' => $policy->customer_id,
            'policy_id' => $policy->id,      // <--- must be provided
            'claim_id' => $claim->id,
            'garage_name' => $this->faker->company . ' Garage',
            'discharge_date' => $this->faker->dateTimeBetween('-1 year', 'now'),
        ];
    }
}
