<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('claim_notes', function (Blueprint $table) {
            // Primary Key (Manual definition to match SQL's int(11))
            $table->integer('id')->unsigned()->autoIncrement()->primary();
            
            // Foreign Keys
            $table->foreignId('claim_id') // bigint(20) UNSIGNED
                  ->constrained()
                  ->onDelete('cascade');

            $table->foreignId('user_id') // bigint(20) UNSIGNED
                  ->constrained()
                  ->onDelete('cascade');

            // Note Content
            $table->text('note'); // text NOT NULL

            // Timestamp
            $table->timestamp('created_at')->useCurrent(); // DEFAULT CURRENT_TIMESTAMP
        });

        // Explicit database configuration
        Schema::table('claim_notes', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('claim_notes');
    }
};