<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('otp_codes', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id'); // bigint(20) UNSIGNED NOT NULL
            
            // Foreign Key
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            
            // OTP Details
            $table->string('otp_code', 10);
            $table->timestamp('expires_at')->useCurrent()->useCurrentOnUpdate();
            $table->boolean('verified')->default(false);
            
            // Timestamp
            $table->timestamp('created_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('otp_codes', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('otp_codes');
    }
};