<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('claim_approvals', function (Blueprint $table) {
            $table->bigIncrements('id'); // bigint(20) UNSIGNED NOT NULL
            
            // Foreign Keys
            $table->foreignId('claim_id')
                  ->constrained()
                  ->onDelete('cascade');

            $table->foreignId('approved_by')
                  ->nullable()
                  ->constrained('users')
                  ->onDelete('set null');

            // Approval Details
            $table->enum('approval_status', ['approved', 'rejected', 'pending'])
                  ->default('pending');
                  
            $table->text('comments')->nullable();
            
            // Timestamps
            $table->timestamp('decision_date')
                  ->useCurrent()
                  ->useCurrentOnUpdate();
                  
            $table->timestamp('created_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('claim_approvals', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('claim_approvals');
    }
};