<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class NotificationJobsSeeder extends Seeder
{
    public function run()
    {
        $notifications = DB::table('notifications')->get();

        foreach ($notifications as $notification) {
            // You can create multiple jobs per notification if you want
            // Here, let's create 1 job per notification for simplicity

            DB::table('notification_jobs')->insert([
                'notification_id' => $notification->id,
                'job_name' => 'Send ' . strtoupper($notification->channel) . ' Notification #' . $notification->id,
                'status' => 'pending',  // or you can randomize: pending, processing, completed, failed
                'attempts' => 0,
                'scheduled_at' => $notification->scheduled_at ?? Carbon::now()->addMinutes(5),
                'started_at' => null,
                'finished_at' => null,
            ]);
        }
    }
}
