<ul class="nav nav-tabs mb-3" role="tablist">
  @php
      $tabs = [
          'tabCustomer' => 'Customer',
          'tabClaims' => 'Claims',
          'tabPolicies' => 'Policies',
          'tabPayments' => 'Claim Payments',
          'tabSurvey' => 'Surveys',
          'tabGarage' => 'Garage Discharges',
          'tabWorkOrder' => 'Work Orders',
      ];
  @endphp

  @foreach ($tabs as $id => $label)
    <li class="nav-item">
      <a class="nav-link @if ($loop->first) active @endif" data-bs-toggle="tab" href="#{{ $id }}">{{ $label }}</a>
    </li>
  @endforeach
</ul>

<div class="tab-content border rounded shadow-sm p-3 bg-light">
  {{-- Customer Info --}}
  <div class="tab-pane fade show active" id="tabCustomer" role="tabpanel">
    <table class="table table-bordered table-sm mb-0">
    <tbody>
  <tr><th>Name</th><td>{{ $notification->customer->full_name ?? 'N/A' }}</td></tr>
  <tr><th>Email</th><td>{{ $notification->customer->email ?? '—' }}</td></tr>
  <tr><th>Phone</th><td>{{ $notification->customer->phone_number ?? '—' }}</td></tr>
  <tr><th>Preferred Language</th><td>{{ strtoupper($notification->customer->preferred_language ?? 'EN') }}</td></tr>

  @php
      $prefs = $notification->customer->notificationPreference;
  @endphp

  <tr>
    <th>Notification Channels</th>
    <td>
      <div class="form-check form-check-inline">
        <input class="form-check-input" type="checkbox" disabled checked>
        <label class="form-check-label">SMS</label>
      </div>
      <div class="form-check form-check-inline">
        <input class="form-check-input" type="checkbox" disabled {{ $prefs?->via_email ? 'checked' : '' }}>
        <label class="form-check-label">Email</label>
      </div>
      <div class="form-check form-check-inline">
        <input class="form-check-input" type="checkbox" disabled checked >
        <label class="form-check-label">IVR</label>
      </div>
    </td>
  </tr>

  <tr>
    <th>Preferred Notification Language</th>
    <td>{{ strtoupper($prefs?->language ?? 'EN') }}</td>
  </tr>
</tbody>

    </table>
  </div>

  {{-- Claims --}}
  <div class="tab-pane fade" id="tabClaims">
    @forelse($notification->claims ?? [] as $claim)
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Claim #</th>
            <th>Status</th>
            <th>Created At</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>{{ $claim->claim_number }}</td>
            <td><span class="badge bg-info">{{ ucfirst($claim->status) }}</span></td>
            <td>{{ \Carbon\Carbon::parse($claim->created_at)->format('F j, Y') }}</td>
          </tr>
        </tbody>
      </table>
    @empty
      <p class="text-muted">No claims found.</p>
    @endforelse
  </div>

  {{-- Policies --}}
  <div class="tab-pane fade" id="tabPolicies">
    @forelse($notification->policies ?? [] as $policy)
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Policy #</th>
            <th>Coverage</th>
            <th>Expires</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>{{ $policy->policy_number }}</td>
            <td>{{ $policy->coverage_type ?? '-' }}</td>
            <td>{{ \Carbon\Carbon::parse($policy->expiry_date)->format('F j, Y') }}</td>
          </tr>
        </tbody>
      </table>
    @empty
      <p class="text-muted">No policies found.</p>
    @endforelse
  </div>

  {{-- Claim Payments --}}
  <div class="tab-pane fade" id="tabPayments">
    @forelse($notification->claimPayments ?? [] as $payment)
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Amount</th>
            <th>Paid At</th>
            <th>Method</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>{{ number_format($payment->amount, 2) }}</td>
            <td>{{ \Carbon\Carbon::parse($payment->paid_at)->format('F j, Y') }}</td>
            <td>{{ $payment->method ?? '-' }}</td>
          </tr>
        </tbody>
      </table>
    @empty
      <p class="text-muted">No claim payments found.</p>
    @endforelse
  </div>

  {{-- Surveys --}}
  <div class="tab-pane fade" id="tabSurvey">
    @forelse($notification->surveyStatuses ?? [] as $survey)
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Status</th>
            <th>Created At</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><span class="badge bg-success">{{ $survey->survey_status }}</span></td>
            <td>{{ \Carbon\Carbon::parse($survey->created_at)->format('F j, Y') }}</td>
          </tr>
        </tbody>
      </table>
    @empty
      <p class="text-muted">No survey records found.</p>
    @endforelse
  </div>

  {{-- Garage Discharges --}}
  <div class="tab-pane fade" id="tabGarage">
    @forelse($notification->garageDischarges ?? [] as $garage)
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Garage</th>
            <th>Discharged At</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>{{ $garage->garage_name }}</td>
            <td>{{ \Carbon\Carbon::parse($garage->discharge_date)->format('F j, Y') }}</td>
          </tr>
        </tbody>
      </table>
    @empty
      <p class="text-muted">No garage discharge data.</p>
    @endforelse
  </div>

  {{-- Work Orders --}}
  <div class="tab-pane fade" id="tabWorkOrder">
    @forelse($notification->workOrders ?? [] as $work)
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Description</th>
            <th>Created At</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>{{ $work->description }}</td>
            <td>{{ \Carbon\Carbon::parse($work->created_at)->format('F j, Y') }}</td>
          </tr>
        </tbody>
      </table>
    @empty
      <p class="text-muted">No work orders found.</p>
    @endforelse
  </div>

</div>
