@extends('layouts.master')

@section('title', 'Dropzone')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/dropzone.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/filepond.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/filepond-plugin-image-preview.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Dropzone</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Bonus Ui</li>
                <li class="breadcrumb-item f-w-400 active">Dropzone</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Default File Upload</h4>
                        <p class="f-m-light mt-1">We use the create method to turn a<code> &lt;input
                                type="file"&gt;</code> into a FilePond drop
                            area.<code>[https://pqina.nl/filepond/]</code></p>
                    </div>
                    <div class="card-body">
                        <input class="no-preview" type="file">
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Image Preview </h4>
                        <p class="f-m-light mt-1">We use the create method to turn a<code> &lt;input
                                type="file"&gt;</code> into a FilePond drop
                            area.<code>[https://pqina.nl/filepond/]</code></p>
                    </div>
                    <div class="card-body">
                        <input class="show-preview" type="file">
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Single File Upload</h4>
                        <p class="f-m-light mt-1"></p>Use the <code>.dropzone </code> class through create upload files and
                        with that we can upload single file by doing <code>singleFileUpload </code>id.
                    </div>
                    <div class="card-body">
                        <form class="dropzone" id="singleFileUpload" action="/upload.php">
                            <div class="dropzone-wrapper">
                                <div class="dz-message needsclick"><i class="icon-cloud-up"></i>
                                    <h5 class="f-w-600">Drop files here or click to upload.</h5><span
                                        class="note needsclick">(This is just a demo dropzone. Selected files are
                                        <strong>not</strong> actually uploaded.)</span>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-md-6">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Multiple File Upload</h4>
                        <p class="f-m-light mt-1">Use the <code>.dropzone </code> class through create upload files and with
                            that we can upload multiple file by doing <code>multiFileUpload </code>id.</p>
                    </div>
                    <div class="card-body">
                        <form class="dropzone dropzone-secondary" id="multiFileUpload" action="/upload.php">
                            <div class="dz-message needsclick"><i class="icon-cloud-up"></i>
                                <h5 class="f-w-600">Drop files here or click to upload.</h5><span
                                    class="note needsclick">(This is just a demo dropzone. Selected files are
                                    <strong>not</strong> actually uploaded.)</span>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-xl-4">
                <div class="card height-equal">
                    <div class="card-header">
                        <h4>Animated Photo Dropzone</h4>
                        <p class="f-m-light mt-1">Use the <code>.dropzone </code> class through create upload images.
                            Additionally, <code>"fileup" </code>Id thrown pictures can be uploaded.</p>
                    </div>
                    <div class="card-body animated-dropfile">
                        <form name="upload" method="post" action="#" enctype="multipart/form-data"
                            accept-charset="utf-8">
                            <div class="row">
                                <div class="col-md-12 col-md-offset-3 text-center">
                                    <div class="btn-container">
                                        <!-- the three icons: default, ok file (img), error file (not an img)-->
                                        <div class="imgupload mb-2"><i class="fa fa-file-image-o"></i></div>
                                        <div class="imgupload ok"><i class="fa fa-check"></i></div>
                                        <div class="imgupload stop"><i class="fa fa-times"></i></div>
                                        <!-- this field changes dinamically displaying the filename we are trying to upload-->
                                        <p id="namefile">Only pics allowed! (jpg,jpeg,bmp,png)</p>
                                        <!-- our custom btn which which stays under the actual one-->
                                        <button class="btn btn-primary" id="btnup" type="button">Search for your
                                            photo!</button>
                                        <!-- this is the actual file input, is set with opacity=0 beacause we wanna see our custom one-->
                                        <input id="fileup" type="file" name="fileup">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <!-- calendar js-->
    <script src="{{ asset('assets/js/dropzone/dropzone.js') }}"></script>
    <script src="{{ asset('assets/js/dropzone/dropzone-script.js') }}"></script>
    <script src="{{ asset('assets/js/filepond/filepond-plugin-image-preview.js') }}"></script>
    <script src="{{ asset('assets/js/filepond/filepond-plugin-file-rename.js') }}"></script>
    <script src="{{ asset('assets/js/filepond/filepond-plugin-image-transform.js') }}"></script>
    <script src="{{ asset('assets/js/filepond/filepond.js') }}"></script>
    <script src="{{ asset('assets/js/filepond/custom-filepond.js') }}"></script>
    <script src="{{ asset('assets/js/height-equal.js') }}"></script>
    <script src="{{ asset('assets/js/tooltip-init.js') }}"></script>
@endsection
