<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NotificationPreference extends Model
{
    protected $fillable = [
        'customer_id',
        'via_sms',
        'via_email',
        'via_ivr',
        'language',
    ];

    protected $casts = [
        'via_sms' => 'boolean',
        'via_email' => 'boolean',
        'via_ivr' => 'boolean',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}
