<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Customer;
use App\Models\Policy;

class ClaimFactory extends Factory
{
    public function definition(): array
    {
        $status = $this->faker->randomElement([
            'registered',
            'survey',
            'work_order',
            'garage_discharge',
            'payment_completed'
        ]);

        $description = match ($status) {
            'registered' => 'Customer has registered a new claim related to vehicle damage.',
            'survey' => 'Surveyor assigned to inspect the claim area. Awaiting report.',
            'work_order' => 'Repair work order issued to partner garage.',
            'garage_discharge' => 'Garage repair completed. Vehicle discharged to the customer.',
            'payment_completed' => 'Final payment processed and completed to customer or vendor.',
            default => 'Claim is in process.'
        };

        return [
            'customer_id' => Customer::inRandomOrder()->first()?->id ?? Customer::factory(),
            'policy_id' => Policy::inRandomOrder()->first()?->id ?? Policy::factory(),
            'claim_number' => $this->faker->unique()->bothify('CLM###??'),
            'status' => $status,
            'description' => $description,
            'created_at' =>  $this->faker->dateTimeBetween('-2 years', 'now'),
            'updated_at' => now(),
        ];
    }
}
