<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

// database/factories/ClaimsPaymentFactory.php


class ClaimPaymentFactory extends Factory
{
    public function definition(): array
    {
        $policy = \App\Models\Policy::inRandomOrder()->first() ?? \App\Models\Policy::factory()->create();

        $claim = \App\Models\Claim::where('policy_id', $policy->id)->inRandomOrder()->first()
                 ?? \App\Models\Claim::factory()->create([
                     'policy_id' => $policy->id,
                     'customer_id' => $policy->customer_id,
                 ]);

        return [
            'customer_id' => $policy->customer_id,
            'cob' => $policy->class_of_business,
            'policy_id' => $policy->id,        // <-- Integer ID here, NOT the policy_number string
            'claim_id' => $claim->id,
            'payment_completed_at' => $this->faker->dateTimeBetween('-1 year', 'now'),
        ];
    }
}
