<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class CustomerFactory extends Factory
{
    public function definition(): array
    {
        $firstNames = [
            'Abebe', 'Almaz', 'Bereket', 'Kidus', 'Selam', 'Haymanot', 'Tigist', 'Yared', 'Hirut', 'Mulu',
            'Samuel', 'Mekdes', 'Fiker', 'Girma', 'Netsanet', 'Sisay', 'Mesfin', 'Rahel', 'Tadelech', 'Yohannes',
            'Lulit', 'Bezawit', 'Eleni', 'Biniyam', 'Melaku', 'Tsehay', 'Ashenafi', 'Kalkidan', 'Nigist', 'Meklit',
            'Sintayehu', 'Meron', 'Wendimu', 'Tadesse', 'Adanech', 'Yeshi', 'Robel', 'Lidya', 'Daniel', 'Ephrem',
            'Rediet', 'Mikiyas', 'Hanna', 'Mebratu', 'Nebiyu', 'Saba', 'Feven', 'Zewdu', 'Gete', 'Tilahun',
            'Shiferaw', 'Minalu', 'Derartu', 'Jemal', 'Yesuf', 'Haimanot', 'Worku', 'Habtamu', 'Almaz', 'Birhanu',
            'Mahider', 'Amanuel', 'Selamawit', 'Lensa', 'Hibret', 'Nigatu', 'Tsion', 'Gedion', 'Tamirat', 'Abush',
            'Berhan', 'Senait', 'Abel', 'Zenebu', 'Eyob', 'Kidist', 'Yonas', 'Sileshi', 'Mahi', 'Tena', 'Yordanos',
            'Mahlet', 'Betelhem', 'Aster', 'Fitsum', 'Solomon', 'Yeshiwas', 'Arsema', 'Etsegenet', 'Banchi', 'Tigabu',
            'Hirut', 'Dagmawit', 'Tsedey', 'Yidnekachew', 'Winta', 'Haile', 'Fekadu', 'Mikiyas', 'Muluwork', 'Muluken'
        ];

        $middleNames = [
            'Teshome', 'Gebremariam', 'Fikadu', 'Tesfaye', 'Kebede', 'Alemu', 'Demissie', 'Worku', 'Bekele', 'Negash',
            'Moges', 'Haile', 'Gizaw', 'Getachew', 'Assefa', 'Abebe', 'Melese', 'Endale', 'Belay', 'Tefera',
            'Nigussie', 'Addis', 'Girma', 'Shiferaw', 'Taddese', 'Birru', 'Ashenafi', 'Abay', 'Degu', 'Hailu',
            'Beyene', 'Tadele', 'Negatu', 'Gebru', 'Gebeyehu', 'Mekonnen', 'Ayalew', 'Wolde', 'Mamo', 'Hunde',
            'Fekadu', 'Demelash', 'Wondimu', 'Tilahun', 'Yimer', 'Amare', 'Belachew', 'Tarekegn', 'Misganaw', 'Zewdu',
            'Getnet', 'Aklilu', 'Gobeze', 'Tsegaye', 'Fantahun', 'Guta', 'Habte', 'Admasu', 'Endeshaw', 'Mesfin',
            'Berhanu', 'Hailemariam', 'Tsegaw', 'Desalegn', 'Hagos', 'Kassahun', 'Asefa', 'Bogale', 'Bayu', 'Gebregziabher'
        ];

        $lastNames = $middleNames; // In Ethiopian naming, last name is often father/middle name

        $first = $this->faker->randomElement($firstNames);
        $middle = $this->faker->randomElement($middleNames);
        $last = $this->faker->randomElement($lastNames);

        $fullName = "$first $middle $last";

        // Generate email based on full name
        $emailUser = strtolower(Str::slug("{$first}.{$last}"));
        $email = $emailUser . rand(100, 999) . '@example.com';

        return [
            'full_name' => $fullName,
            'phone_number' => '+2519' . $this->faker->unique()->numerify('########'),
            'email' => $email,
            'preferred_language' => $this->faker->randomElement(['am', 'en','tg', 'sm','om']),
            'is_active' => true,
        ];
    }
}
