<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Policy;
use App\Models\Claim;
use App\Models\Customer;

class SurveyStatusFactory extends Factory
{
    public function definition(): array
    {
        $policy = Policy::inRandomOrder()->first();

        if (!$policy) {
            return []; // avoid error if no policy exists
        }

        $claim = Claim::where('policy_id', $policy->id)->inRandomOrder()->first();
        $customer = Customer::find($policy->customer_id);

        $status = $this->faker->randomElement(['Pending', 'Completed']);

        $riskTypes = [
            'fire damage risk due to nearby combustible materials',
            'flood exposure from adjacent river overflow',
            'theft vulnerability due to lack of security systems',
            'natural disaster risk from earthquakes or landslides',
            'accidental damage risk from electrical faults',
            'chemical hazard from on-site flammable substances',
        ];

        return [
            'customer_id' => $policy->customer_id,
            'customer_mobile' => $customer?->phone_number ?? '+2519' . $this->faker->numerify('########'),
            'cob' => $policy->class_of_business,
            'policy_id' => $policy->id,
            'claim_id' => $claim?->id,
            'survey_status' => $status,
            'completion_date' => $status === 'Completed'
                ? $this->faker->dateTimeBetween('-1 year', 'now')
                : null,
            'description' => 'Survey conducted to assess ' . $this->faker->randomElement($riskTypes) . '.',
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
