<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('login_attempts', function (Blueprint $table) {
            // Primary Key
            $table->increments('id'); // int(11) NOT NULL AUTO_INCREMENT
            
            // Foreign Key (Nullable)
            $table->foreignId('user_id')
                ->nullable()
                ->constrained()
                ->onDelete('set null');

            // Login Details
            $table->string('email', 255);
            $table->string('ip_address', 45);
            $table->enum('status', ['successful', 'failed']);
            $table->text('reason')->nullable();

            // Timestamp
            $table->timestamp('created_at')->useCurrent();
        });

        // Explicit database configuration
        Schema::table('login_attempts', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('login_attempts');
    }
};