<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('add_ons', function (Blueprint $table) {
            $table->bigIncrements('id'); // bigint(20) UNSIGNED NOT NULL
            
            $table->foreignId('policy_id') // bigint(20) UNSIGNED NOT NULL
                  ->constrained()
                  ->onDelete('cascade');

            $table->enum('addon_type', [
                'coverage_extension',
                'roadside_assistance',
                'equipment_protection'
            ]);

            $table->decimal('cost', 15, 2); // DECIMAL(15,2) NOT NULL

            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrent()->useCurrentOnUpdate();
        });

        // Set engine and collation explicitly
        Schema::table('add_ons', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('add_ons');
    }
};