<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->bigIncrements('id'); // BIGINT(20) UNSIGNED NOT NULL
            
            $table->foreignId('user_id') // BIGINT(20) UNSIGNED NOT NULL
                ->constrained()
                ->onDelete('cascade');

            $table->enum('type', ['email', 'sms', 'system'])
                ->default('system');

            $table->text('message');
            $table->boolean('read_status')->default(false); // TINYINT(1) DEFAULT 0
            $table->timestamp('sent_at')->nullable()->useCurrent();

            $table->timestamps(); // Optional if you need created_at/updated_at
        });

        // Explicit database configuration
        Schema::table('notifications', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('notifications');
    }
};