<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('template_change_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('template_id')->constrained('notification_templates')->onDelete('cascade');
            $table->unsignedBigInteger('user_id')->nullable(); // who made the change
            $table->text('change_summary'); // short description of change
            $table->json('old_content')->nullable(); // old content as JSON or text
            $table->json('new_content')->nullable(); // new content as JSON or text
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('template_change_logs');
    }
};
