<?php



namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Customer;
use App\Models\NotificationPreference;

class NotificationPreferenceSeeder extends Seeder
{
    public function run(): void
    {
        $customers = Customer::all();

        foreach ($customers as $customer) {
            NotificationPreference::updateOrCreate(
                ['customer_id' => $customer->id],
                [
                    'via_sms'    => fake()->boolean(80), // 80% chance of opting in
                    'via_email'  => fake()->boolean(70),
                    'via_ivr'    => fake()->boolean(60),
                    'language'   => $customer->preferred_language ?? 'en',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]
            );
        }
    }
}
