@extends('layouts.master')

@section('title', 'Basic Tables')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Bootstrap Basic Tables</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Bootstrap Tables</li>
                <li class="breadcrumb-item f-w-400 active">Bootstrap Basic Tables</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid basic_table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Basic Table With Border Bottom Color</h4><span>Use a class<code>table</code> to any table, and
                            <code>.border-bottom-*</code>class for Border bottom color</span>
                    </div>
                    <div class="table-responsive theme-scrollbar">
                        <table class="table">
                            <thead>
                                <tr class="border-bottom-primary">
                                    <th scope="col">Id</th>
                                    <th scope="col">First Name</th>
                                    <th scope="col">Last Name</th>
                                    <th scope="col">Username</th>
                                    <th scope="col">Designation</th>
                                    <th scope="col">Company</th>
                                    <th scope="col">Language</th>
                                    <th scope="col">Country</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="border-bottom-secondary">
                                    <th scope="row">1</th>
                                    <td> <img class="img-30 me-2" src="{{ asset('assets/images/user/1.jpg') }}"
                                            alt="profile">Ram Jacob
                                    </td>
                                    <td>Wolfe</td>
                                    <td>RamJacob@twitter</td>
                                    <td>Developer</td>
                                    <td>Apple Inc.</td>
                                    <td> <span class="badge badge-light-danger">Php</span></td>
                                    <td>IND</td>
                                </tr>
                                <tr class="border-bottom-success">
                                    <th scope="row">2</th>
                                    <td> <img class="img-30 me-2" src="{{ asset('assets/images/user/2.jpg') }}"
                                            alt="profile">John Deo
                                    </td>
                                    <td>Gummer</td>
                                    <td>JohnDeo@twitter </td>
                                    <td>Designer</td>
                                    <td>Hewlett packard </td>
                                    <td> <span class="badge badge-light-primary">Html</span></td>
                                    <td>US</td>
                                </tr>
                                <tr class="border-bottom-info">
                                    <th scope="row">3</th>
                                    <td> <img class="img-30 me-2" src="{{ asset('assets/images/user/3.jpg') }}"
                                            alt="profile">Elana
                                        John</td>
                                    <td>Cazale </td>
                                    <td>ElanaJohn@twitter</td>
                                    <td>Designer</td>
                                    <td>Microsoft</td>
                                    <td> <span class="badge badge-light-danger">Pug</span></td>
                                    <td>UK</td>
                                </tr>
                                <tr class="border-bottom-warning">
                                    <th scope="row">4</th>
                                    <td> <img class="img-30 me-2" src="{{ asset('assets/images/user/7.jpg') }}"
                                            alt="">Meryl
                                        Streep</td>
                                    <td>Roberts</td>
                                    <td>MerylStreep@twitter</td>
                                    <td>Developer</td>
                                    <td>Tata Ltd. </td>
                                    <td> <span class="badge badge-light-success">React</span></td>
                                    <td>IDN</td>
                                </tr>
                                <tr class="border-bottom-danger">
                                    <th scope="row">5</th>
                                    <td> <img class="img-30 me-2" src="{{ asset('assets/images/user/2.png') }}"
                                            alt="">Emma
                                        Stone</td>
                                    <td>Stone</td>
                                    <td>EmmaStone@twitter </td>
                                    <td>Developer</td>
                                    <td>Wipro Ltd. </td>
                                    <td> <span class="badge badge-light-primary">Vue</span></td>
                                    <td>IRN</td>
                                </tr>
                                <tr class="border-bottom-light">
                                    <th scope="row">6</th>
                                    <td> <img class="img-30 me-2" src="{{ asset('assets/images/user/3.png') }}"
                                            alt="">Eliana
                                        Jons</td>
                                    <td>Jons</td>
                                    <td>ElianaJons@twitter </td>
                                    <td>Developer</td>
                                    <td>Info Ltd. </td>
                                    <td> <span class="badge badge-light-success">Vue</span></td>
                                    <td>IRN</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Inverse Table</h4><span>Use a class <code>table-inverse</code> inside table element.</span>
                    </div>
                    <div class="table-responsive theme-scrollbar">
                        <table class="table table-inverse">
                            <thead>
                                <tr class="border-bottom-light">
                                    <th scope="col">Id</th>
                                    <th scope="col">First Name</th>
                                    <th scope="col">Last Name</th>
                                    <th scope="col">Office</th>
                                    <th scope="col">Position</th>
                                    <th scope="col">Salary</th>
                                    <th scope="col">Join Date </th>
                                    <th scope="col">Age</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th scope="row">1</th>
                                    <td>Stephan</td>
                                    <td>Laiten</td>
                                    <td>Tokyo</td>
                                    <td>Accountant</td>
                                    <td>$2100.00 </td>
                                    <td>21/01/2024 </td>
                                    <td>20 </td>
                                </tr>
                                <tr>
                                    <th scope="row">2</th>
                                    <td>Fay </td>
                                    <td>Van Damme </td>
                                    <td>London </td>
                                    <td>CEO</td>
                                    <td>$1420.00 </td>
                                    <td>14/02/2024 </td>
                                    <td>22</td>
                                </tr>
                                <tr>
                                    <th scope="row">3</th>
                                    <td>Brevin </td>
                                    <td>Oleveria</td>
                                    <td>New York </td>
                                    <td>Software Engineer </td>
                                    <td>$1340.00 </td>
                                    <td>04/06/2024 </td>
                                    <td>18 </td>
                                </tr>
                                <tr>
                                    <th scope="row">4</th>
                                    <td>Regina</td>
                                    <td>Ottandy </td>
                                    <td>France </td>
                                    <td>Pre-sale Support </td>
                                    <td>$3400.00 </td>
                                    <td>10/08/2024 </td>
                                    <td>25 </td>
                                </tr>
                                <tr>
                                    <th scope="row">5</th>
                                    <td>Vani</td>
                                    <td>Shah </td>
                                    <td>Los Angeles </td>
                                    <td>Senior Developer </td>
                                    <td>$3500.00 </td>
                                    <td>23/07/2024 </td>
                                    <td>28 </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Hoverable Rows With Horizontal Border</h4><span>Hoverable row use a class
                            <code>table-hover</code> and for Horizontal border use a class
                            <code>.table-border-horizontal</code> , dashed border Use a class<code>.border-dashed
                                .table</code>class.</span>
                    </div>
                    <div class="table-responsive theme-scrollbar signal-table">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th scope="col">Id</th>
                                    <th scope="col">Status</th>
                                    <th scope="col">Signal Name </th>
                                    <th scope="col">Security</th>
                                    <th scope="col">Stage</th>
                                    <th scope="col">Schedule</th>
                                    <th scope="col">Team Lead</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th scope="row">1</th>
                                    <td class="d-flex align-items-center"><i class="bg-light-success font-success"
                                            data-feather="alert-triangle"></i><span class="font-success">No Signal</span>
                                    </td>
                                    <td>Astrid: NE Shared managed</td>
                                    <td>Medium</td>
                                    <td>Triaged</td>
                                    <td>0.33 </td>
                                    <td>Chase Nguyen </td>
                                </tr>
                                <tr>
                                    <th scope="row">2</th>
                                    <td class="d-flex align-items-center"><i class="bg-light-danger font-danger"
                                            data-feather="alert-triangle"></i><span class="font-danger">Offline</span>
                                    </td>
                                    <td>Cosmo: prod shared ares </td>
                                    <td>Huge</td>
                                    <td>Triaged</td>
                                    <td>0.39</td>
                                    <td>Brie Furman</td>
                                </tr>
                                <tr>
                                    <th scope="row">3</th>
                                    <td class="d-flex align-items-center"> <i class="bg-light-primary font-primary"
                                            data-feather="alert-circle"></i><span class="font-primary">Online</span></td>
                                    <td>Phoenix: prod shared lyra-lists </td>
                                    <td>Minor</td>
                                    <td>No Triaged</td>
                                    <td>3.12 </td>
                                    <td>Jeremy Lake</td>
                                </tr>
                                <tr>
                                    <th scope="row">4</th>
                                    <td class="d-flex align-items-center"> <i class="bg-light-success font-success"
                                            data-feather="check-circle"></i><span class="font-success">No Signal</span>
                                    </td>
                                    <td>Astrid: NE Shared managed</td>
                                    <td>Negligible</td>
                                    <td>Triaged</td>
                                    <td>13.18</td>
                                    <td>Angelica Howards</td>
                                </tr>
                                <tr>
                                    <th scope="row">5</th>
                                    <td class="d-flex align-items-center"> <i class="bg-light-danger font-danger"
                                            data-feather="check-circle"></i><span class="font-danger">Online</span></td>
                                    <td>Astrid: NE Shared managed</td>
                                    <td>Medium</td>
                                    <td>No Triaged</td>
                                    <td>5.33 </td>
                                    <td>Diane Okuma</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Inverse Table with Primary background</h4><span>Use a class <code>.bg-info, .bg-success,
                                .bg-warning and .bg-danger classes.</code> with light text on dark backgrounds inside table
                            element.<br>To set the light background color use .bg-[color] class where [color] is the value
                            of your selected color from stack color palette. So for teal color background class will be
                            .bg-teal</span>
                    </div>
                    <div class="table-responsive theme-scrollbar">
                        <table class="table table-striped bg-primary">
                            <thead class="tbl-strip-thad-bdr">
                                <tr>
                                    <th scope="col">Id</th>
                                    <th scope="col">First Name</th>
                                    <th scope="col">Last Name</th>
                                    <th scope="col">Company</th>
                                    <th scope="col">Credit Volume </th>
                                    <th scope="col">Username</th>
                                    <th scope="col">Role </th>
                                    <th scope="col">Country</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th scope="row">1</th>
                                    <td>Ram Jacob </td>
                                    <td>Wolfe</td>
                                    <td>Apple Inc. </td>
                                    <td>$3500.00 </td>
                                    <td>RamJacob@twitter </td>
                                    <td>Developer</td>
                                    <td>IND</td>
                                </tr>
                                <tr>
                                    <th scope="row">2</th>
                                    <td>John Deo </td>
                                    <td>Gummer </td>
                                    <td>Hewlett packard </td>
                                    <td>$2400.00</td>
                                    <td>JohnDeo@twitter </td>
                                    <td>Designer</td>
                                    <td>US</td>
                                </tr>
                                <tr>
                                    <th scope="row">3</th>
                                    <td>Elana John </td>
                                    <td>Wolfe</td>
                                    <td>Microsoft </td>
                                    <td>$2560.00 </td>
                                    <td>ElanaJohn@twitter </td>
                                    <td>Designer</td>
                                    <td>UK</td>
                                </tr>
                                <tr>
                                    <th scope="row">4</th>
                                    <td>Meryl Streep </td>
                                    <td>Roberts</td>
                                    <td>Tata Ltd. </td>
                                    <td>$1870.00</td>
                                    <td>MerylStreep@twitter </td>
                                    <td>Developer</td>
                                    <td>IND</td>
                                </tr>
                                <tr>
                                    <th scope="row">5</th>
                                    <td>Emma Stone </td>
                                    <td>Stone</td>
                                    <td>Wipro Ltd. </td>
                                    <td>$4580.00 </td>
                                    <td>EmmaStone@twitter </td>
                                    <td>Developer</td>
                                    <td>IRN</td>
                                </tr>
                                <tr>
                                    <th scope="row">6</th>
                                    <td>Eliana Jons </td>
                                    <td>Jons</td>
                                    <td>Info Ltd. </td>
                                    <td>$4580.00 </td>
                                    <td>ElianaJons@twitter </td>
                                    <td>Developer</td>
                                    <td>IRN</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Caption</h4><span>A <code>&lt;caption&gt;</code> functions like a heading for a table. It helps
                            users with screen readers to find a table and understand what it’s about and decide if they want
                            to read it.</span>
                    </div>
                    <div class="card-block row">
                        <div class="col-sm-12 col-lg-12 col-xl-12">
                            <div class="table-responsive theme-scrollbar">
                                <table class="table">
                                    <caption class="px-3">List of users</caption>
                                    <thead>
                                        <tr>
                                            <th scope="col">Id</th>
                                            <th scope="col">Employee Name </th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Experience</th>
                                            <th scope="col">Sex</th>
                                            <th scope="col">Contact No. </th>
                                            <th scope="col">Age</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">1</th>
                                            <td>Elana Robbert </td>
                                            <td>ElanaRob@gmail.com </td>
                                            <td>1 Year </td>
                                            <td>Male </td>
                                            <td>+91 9789887777 </td>
                                            <td>28 </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">2</th>
                                            <td>Stiphen Deo </td>
                                            <td>Stiphen@yahoo.com </td>
                                            <td>6 Month </td>
                                            <td>Female</td>
                                            <td>+91 9874563210 </td>
                                            <td>22 </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">3</th>
                                            <td>Genelia Ottre </td>
                                            <td>Genelia@gmail.com </td>
                                            <td>2 Days </td>
                                            <td>Male </td>
                                            <td>+91 8794562135 </td>
                                            <td>24 </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Table head options</h4><span>Similar to tables , use the modifier
                            classes<code>.table-[color]</code> to make <code>thead</code>appear in any color.</span>
                    </div>
                    <div class="card-block row">
                        <div class="col-sm-12 col-lg-12 col-xl-12">
                            <div class="table-responsive theme-scrollbar">
                                <table class="table">
                                    <thead class="table-dark">
                                        <tr>
                                            <th scope="col">Id</th>
                                            <th scope="col">First Name</th>
                                            <th scope="col">Last Name</th>
                                            <th scope="col">Username</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">1</th>
                                            <td>Mark</td>
                                            <td>Otto</td>
                                            <td>@mdo</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">2</th>
                                            <td>Jacob</td>
                                            <td>Thornton</td>
                                            <td>@fat</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">3</th>
                                            <td>Larry</td>
                                            <td>the Bird</td>
                                            <td>@twitter</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h4>Striped Row with Inverse Table</h4><span>Use <code>.table-striped</code> to add zebra-striping
                            to any table row within the <code></code>. This styling doesn't work in IE8 and below as
                            :nth-child CSS selector isn't supported.</span>
                    </div>
                    <div class="card-block row">
                        <div class="col-sm-12 col-lg-12 col-xl-12">
                            <div class="table-responsive theme-scrollbar">
                                <table class="table table-inverse table-striped">
                                    <thead>
                                        <tr>
                                            <th scope="col">Id</th>
                                            <th scope="col">Dessert</th>
                                            <th scope="col">Calories</th>
                                            <th scope="col">Fat</th>
                                            <th scope="col">Price</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">1</th>
                                            <td>KitKat</td>
                                            <td>518</td>
                                            <td>26</td>
                                            <td>20</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">2</th>
                                            <td>Donut</td>
                                            <td>452</td>
                                            <td>25</td>
                                            <td>80</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">3</th>
                                            <td>Eclair</td>
                                            <td>262</td>
                                            <td>16</td>
                                            <td>10</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Breckpoint Specific</h4><span>Use <code>.table-responsive"❴-sm|-md|-lg|-xl|-xxl❵"</code>
                            functions like a heading for a table. It helps users with screen readers to find a table and
                            understand what it’s about and decide if they want to read it.</span>
                    </div>
                    <div class="card-block row">
                        <div class="col-sm-12 col-lg-12 col-xl-12">
                            <div class="table-responsive theme-scrollbar">
                                <table class="table table-responsive-sm">
                                    <thead>
                                        <tr>
                                            <th scope="col">Id</th>
                                            <th scope="col">Name</th>
                                            <th scope="col">Order Id </th>
                                            <th scope="col">Price</th>
                                            <th scope="col">Quantity</th>
                                            <th scope="col">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">1</th>
                                            <td>Iphone X Grey </td>
                                            <td>C12345</td>
                                            <td>$12550 </td>
                                            <td>1</td>
                                            <td>$12550</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">2</th>
                                            <td>Titan Watch </td>
                                            <td>A14725 </td>
                                            <td>$120</td>
                                            <td>2</td>
                                            <td>$250</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">3</th>
                                            <td>Apple Airpods </td>
                                            <td>B54213</td>
                                            <td>$210 </td>
                                            <td>1</td>
                                            <td>$210</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Responsive Tables With Light Background</h4><span>A <code>.table-responsive ,.light-card</code>
                            inside table element.</span>
                    </div>
                    <div class="card-block row">
                        <div class="col-sm-12 col-lg-12 col-xl-12">
                            <div class="table-responsive theme-scrollbar">
                                <table class="table light-card">
                                    <thead>
                                        <tr>
                                            <th scope="col">Id</th>
                                            <th scope="col">Task</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Phone</th>
                                            <th scope="col">Assign</th>
                                            <th scope="col">Date</th>
                                            <th scope="col">Price </th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Progress</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">1</th>
                                            <td>Web Development </td>
                                            <td>Pixel@efo.com </td>
                                            <td>+91 7874226671 </td>
                                            <td>Mark Jecno </td>
                                            <td>12/07/2024 </td>
                                            <td>$2315.00 </td>
                                            <td class="font-danger">Pending</td>
                                            <td>75%</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">2</th>
                                            <td>Graphic Design </td>
                                            <td>Strap@google.com </td>
                                            <td>+91 8347855785 </td>
                                            <td>Elana John </td>
                                            <td>23/08/2024 </td>
                                            <td>$4125.00 </td>
                                            <td class="font-danger">Pending </td>
                                            <td>45%</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">3</th>
                                            <td>WordPress</td>
                                            <td>Pixelstrap@gmail.com </td>
                                            <td>+91 635609347 </td>
                                            <td>John Deo</td>
                                            <td>15/04/2024 </td>
                                            <td>$6123.00 </td>
                                            <td class="font-success">Done</td>
                                            <td>100%</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Sizing Tables</h4><span>Example of Extra large table, Add<code>.table-xl</code> class to
                            the<code>.table</code> , Large table Add <code> .table-lg</code> , Default table Add
                            <code>.table-de</code> , Small table Add <code>.table-sm </code>, Extra Small table Add
                            <code>.table-xs</code>to create a table.</span>
                    </div>
                    <div class="card-block row">
                        <div class="col-sm-12 col-lg-12 col-xl-12">
                            <div class="table-responsive theme-scrollbar">
                                <table class="table table-lg">
                                    <thead>
                                        <tr>
                                            <th scope="col">Id</th>
                                            <th scope="col">Employee Name</th>
                                            <th scope="col">Date</th>
                                            <th scope="col">Status</th>
                                            <th scope="col">Hours</th>
                                            <th scope="col">Performance</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">1</th>
                                            <td>Mark Jecno </td>
                                            <td>22/08/2024 </td>
                                            <td class="font-danger">On leave </td>
                                            <td>0</td>
                                            <td>29/30</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">2</th>
                                            <td>Elana Robbert </td>
                                            <td>21/08/2024 </td>
                                            <td class="font-success">Present</td>
                                            <td>10</td>
                                            <td>30/30</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">3</th>
                                            <td>John Deo </td>
                                            <td>18/08/2024</td>
                                            <td class="font-danger">On leave </td>
                                            <td>8</td>
                                            <td>28/30</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h4>Custom Table Color With Hover And Stripped</h4><span>Use class <code>table-hover, table-striped
                                table-*table-info,table-success,table-success,table-info,table-danger,table-primary,table-secondary,table-light,table-active</code>
                            inside table element.</span>
                    </div>
                    <div class="table-responsive theme-scrollbar">
                        <table class="table table-striped bg-primary hover">
                            <thead class="tbl-strip-thad-bdr">
                                <tr>
                                    <th scope="col">Id</th>
                                    <th scope="col">Film Title</th>
                                    <th scope="col">Released</th>
                                    <th scope="col">Studio</th>
                                    <th scope="col">Budget </th>
                                    <th scope="col">Domestic Gross</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th scope="row">1</th>
                                    <td>Frozen </td>
                                    <td>2013 </td>
                                    <td>Disney </td>
                                    <td>$150,000,000</td>
                                    <td>$400,953,009</td>
                                </tr>
                                <tr>
                                    <th scope="row">2</th>
                                    <td>Minions </td>
                                    <td>2015 </td>
                                    <td>Universal </td>
                                    <td>$74,000,000</td>
                                    <td>$336,045,770</td>
                                </tr>
                                <tr>
                                    <th scope="row">3</th>
                                    <td>Zootopia </td>
                                    <td>2016 </td>
                                    <td>Disney </td>
                                    <td>$150,000,000</td>
                                    <td>$341,268,248</td>
                                </tr>
                                <tr>
                                    <th scope="row">4</th>
                                    <td>Finding Dory </td>
                                    <td>2016</td>
                                    <td>Disney Pixar</td>
                                    <td>$175,000,000</td>
                                    <td> $486,295,561</td>
                                </tr>
                                <tr>
                                    <th scope="row">5</th>
                                    <td>Toy Story 3 </td>
                                    <td>2010</td>
                                    <td>Disney Pixar</td>
                                    <td>$200,000,000</td>
                                    <td>$415,004,880</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header border-bottom-0">
                        <h4>Dashed Border </h4><span>Dashed border use class <code>.table-dashed</code> , for Dotted border
                            use class<code>.table-dotted</code>, for Double border use
                            class<code>.table-Double</code></span>
                    </div>
                    <div class="card-block row">
                        <div class="col-sm-12 col-lg-12 col-xl-12">
                            <div class="table-responsive theme-scrollbar">
                                <table class="table table-dashed">
                                    <thead>
                                        <tr>
                                            <th scope="col">Id </th>
                                            <th scope="col">Classname</th>
                                            <th scope="col">Type</th>
                                            <th scope="col">Hours</th>
                                            <th scope="col">Trainer</th>
                                            <th scope="col">Spots</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">1</th>
                                            <td>Crit Cardio</td>
                                            <td>Gym</td>
                                            <td>9:00 AM - 11:00 AM </td>
                                            <td>Aaron Chapman </td>
                                            <td>10</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">2</th>
                                            <td>Zumba Dance</td>
                                            <td>Dance</td>
                                            <td>8:00 AM - 9:00 AM </td>
                                            <td>Donna Wilson </td>
                                            <td>12</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">3</th>
                                            <td>Like a butterfly </td>
                                            <td>Boxing</td>
                                            <td>9:00 AM - 10:00 AM </td>
                                            <td>Randy Porter </td>
                                            <td>13</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">4</th>
                                            <td>Pilates Reformer </td>
                                            <td>Gym</td>
                                            <td>7:00 AM - 8:30 AM </td>
                                            <td>Aaron Chapman </td>
                                            <td>15</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">5</th>
                                            <td>Mind & Body </td>
                                            <td>Yoga</td>
                                            <td>8:00 AM - 9:00 AM </td>
                                            <td>Adam Stewart </td>
                                            <td>20</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')

@endsection
