<?php $__env->startSection('title', 'Admin Dashboard'); ?>

<?php $__env->startSection('css'); ?>

    <style>
        .progress-bar.productive {
            background-color: #28a745;
            /* SMS */
        }

        .progress-bar.middle {
            background-color: #007bff;
            /* Email */
        }

        .progress-bar.idle {
            background-color: #ffc107;
            /* IVR */
        }
    </style>


<?php $__env->stopSection(); ?>




<?php $__env->startSection('main_content'); ?>

    <div class="container-fluid mt-3">
        <div class="row">
            <div class="row">
                <div class="col-lg-6 col-xxl-4">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="card project-total-card">
                                <div class="card-body">
                                    <div class="d-flex position-relative">
                                        <h5 class="text-dark txt-ellipsis-1">Notification Channel Usage</h5>
                                        <div class="clock-box">
                                            <div class="clock">
                                                <div class="hour" id="hour"></div>
                                                <div class="min" id="min"></div>
                                                <div class="sec" id="sec"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="d-flex">
                                            <h2 class="text-info-dark hour-display" id="totalCoun"></h2>
                                        </div>

                                        <div class="progress-labels mg-t-40">
                                            <span class="text-info" style="cursor: pointer;"
                                                onclick="loadChannelData('sms')">SMS</span>
                                            <span class="text-info" style="cursor: pointer;"
                                                onclick="loadChannelData('email')">Email</span>
                                            <span class="text-info" style="cursor: pointer;"
                                                onclick="loadChannelData('ivr')">IVR</span>
                                        </div>

                                        <div class="custom-progress-container info-progress">
                                            <div class="progress-bar productive"></div>
                                            <div class="progress-bar middle"></div>
                                            <div class="progress-bar idle"></div>
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <div class="card bg-info-300 project-details-card">
                                <div class="card-body">
                                    <div class="d-flex gap-2">
                                        <span class="badge bg-white-300 text-info-dark p-1  b-r-10">📱 Mobile
                                            app</span>
                                        <span class="badge dashed-1-info text-info-dark ms-2 p-1  b-r-10">Marketing</span>
                                    </div>
                                    <div class="my-4">
                                        <h5 class="f-w-600 text-info-dark txt-ellipsis-1">Project Alpha</h5>
                                        <p class="text-info f-s-13 txt-ellipsis-1 mb-0">Revolutionizing ideas,
                                            empowering innovation, and driving success.</p>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-between pt-3">
                                        <ul class="avatar-group">
                                            <li
                                                class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-light-primary b-2-primary">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/4.png')); ?>">
                                            </li>
                                            <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-light-success b-2-success"
                                                data-bs-title="Lennon Briggs" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/5.png')); ?>">
                                            </li>
                                            <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-light-info b-2-info"
                                                data-bs-title="Maya Horton" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/6.png')); ?>">
                                            </li>
                                        </ul>
                                        <span class="badge bg-white-300 text-info-dark ms-2 ">🔥 1H left</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <div class="card bg-success-300 project-details-card">
                                <div class="card-body">
                                    <div class="d-flex gap-2">
                                        <span class="badge bg-white-300 text-success-dark p-1 b-r-10">⚡ API
                                        </span>
                                        <span
                                            class="badge bg-transparent dashed-1-dark-light text-success-dark ms-2 p-1 b-r-10">Web
                                            Development</span>
                                    </div>
                                    <div class="my-4">
                                        <h5 class="f-w-600 text-success-dark txt-ellipsis-1">Project Beta</h5>
                                        <p class="text-success f-s-13 txt-ellipsis-1 mb-0"> Innovating solutions
                                            for seamless task management efficiency.</p>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-between pt-3">
                                        <ul class="avatar-group">
                                            <li
                                                class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-light-primary b-2-primary">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/4.png')); ?>">
                                            </li>
                                            <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-light-danger b-2-danger"
                                                data-bs-title="Maya Horton" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/6.png')); ?>">
                                            </li>
                                        </ul>
                                        <span class="badge bg-white-300 text-success-dark ms-2 ">✨ 2D
                                            left</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <div class="card core-teams-card">
                                <div class="card-body">
                                    <div class="d-flex">
                                        <h5 class="text-dark f-w-600 txt-ellipsis-1">💼 Core Teams</h5>
                                    </div>
                                    <div>
                                        <h2 class="text-warning-dark my-4 d-inline-flex align-items-baseline">1k
                                            <span class="f-s-12 text-dark">Team Members</span>
                                        </h2>
                                        <ul class="avatar-group justify-content-start ">
                                            <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden text-bg-primary b-2-light"
                                                data-bs-title="Sabrina Torres" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/4.png')); ?>">
                                            </li>
                                            <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden text-bg-success b-2-light"
                                                data-bs-title="Eva Bailey" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/5.png')); ?>">
                                            </li>
                                            <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden text-bg-danger b-2-light"
                                                data-bs-title="Michael Hughes" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/6.png')); ?>">
                                            </li>
                                            <li class="text-bg-secondary h-35 w-35 d-flex-center b-r-50"
                                                data-bs-title="10 More" data-bs-toggle="tooltip">
                                                10+
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-7 col-xxl-6 order-1-md">
                            <div class="p-3">
                                <h5>Tracker</h5>
                            </div>
                            <div class="card">
                                <div class="card-body position-relative">
                                    <div class="time-tracker">
                                        <div class="share-time">
                                            <div class="dropdown">
                                                <span aria-expanded="false"
                                                    class="w-35 h-35 bg-primary-300 text-info-dark rounded p-2 d-flex-center"
                                                    data-bs-toggle="dropdown" role="button">
                                                    <i class="iconoir-share-android-solid"></i>
                                                </span>
                                                <ul class="dropdown-menu  dropdown-menu-end rounded">
                                                    <li><a class="dropdown-item f-s-14" href="#"><i
                                                                class="iconoir-instagram text-danger-dark me-2 f-s-18 align-text-top"></i>Instagram</a>
                                                    </li>
                                                    <li><a class="dropdown-item f-s-14" href="#"><i
                                                                class="iconoir-twitter text-twitter me-2 f-s-18 align-text-top"></i>Twitter</a>
                                                    </li>
                                                    <li><a class="dropdown-item f-s-14" href="#"><i
                                                                class="iconoir-chat-lines text-whatsapp me-2 f-s-18 align-text-top"></i>Messenger</a>
                                                    </li>
                                                    <li><a class="dropdown-item f-s-14" href="#"><i
                                                                class="iconoir-more-horiz text-dark me-2 f-s-18 align-text-top"></i>Other
                                                            Apps</a></li>
                                                </ul>
                                            </div>
                                        </div>
                                        <h2 class="timer-display f-w-600">00:00:00</h2>
                                        <div class="controls">
                                            <button class="btn btn-light-primary icon-btn b-r-18" id="start-btn"><i
                                                    class="iconoir-play-solid"></i></button>
                                            <button class="btn btn-danger icon-btn b-r-18" disabled id="stop-btn"><i
                                                    class="iconoir-square"></i></button>
                                            <button class="btn btn-light-info icon-btn b-r-18" id="reset-btn"><i
                                                    class="iconoir-refresh"></i></button>
                                        </div>
                                    </div>

                                    <ul class="tracker-history-list app-scroll mt-3">
                                        <li class="bg-info-300">
                                            <div>
                                                <h6 class="text-info-dark mb-0">Session 1</h6>
                                            </div>
                                            <div class="text-dark f-w-600 ms-2">
                                                00:01:23
                                            </div>
                                        </li>

                                        <li class="bg-primary-300">
                                            <div>
                                                <h6 class="text-primary-dark mb-0">Session 2</h6>
                                            </div>
                                            <div class="text-dark f-w-600 ms-2">
                                                00:02:45
                                            </div>
                                        </li>
                                        <li class="bg-danger-300">
                                            <div>
                                                <h6 class="text-danger-dark mb-0">Session 3</h6>
                                            </div>
                                            <div class="text-dark f-w-600 ms-2">
                                                00:03:30
                                            </div>
                                        </li>
                                        <li class="bg-warning-300">
                                            <div>
                                                <h6 class="text-warning-dark mb-0">Session 4</h6>
                                            </div>
                                            <div class="text-dark f-w-600 ms-2">
                                                00:04:12
                                            </div>
                                        </li>
                                        <li class="bg-success-300">
                                            <div>
                                                <h6 class="text-success-dark mb-0">Session 5</h6>
                                            </div>
                                            <div class="text-dark f-w-600 ms-2">
                                                01:06:00
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>







            <div class="col-lg-7 col-xxl-6 order-1-md">
                <div class="p-3">
                    <h5>Project Status</h5>
                </div>
                <div class="card mb-0">
                    <div class="card-body py-2 px-0 overflow-hidden">
                        <div class="table-responsive app-scroll ">
                            <table class="table align-middle project-status-table mb-0">
                                <thead>
                                    <tr>
                                        <th scope="col">Project</th>
                                        <th scope="col">Status</th>
                                        <th scope="col">TeamLead</th>
                                        <th scope="col">priority</th>
                                        <th scope="col">Remarks</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <h6 class="mb-0 text-success-dark text-nowrap">Web Redesign</h6>
                                        </td>
                                        <td><span class="badge text-light-warning f-s-9 f-w-700">In
                                                Progress</span>
                                        </td>
                                        <td class="f-w-600 text-dark">
                                            <a class="h-30 w-30 d-flex-center b-r-50 overflow-hidden text-bg-secondary m-auto "
                                                data-bs-title="Athena Stewart" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/2.png')); ?>">
                                            </a>


                                        </td>
                                        <td class="text-success-dark f-w-600">
                                            High
                                        </td>
                                        <td>
                                            <span class="text-dark f-s-14 f-w-500 text-nowrap"><i
                                                    class="ti ti-circle-filled me-2 f-s-6"></i> Design phase
                                                completed</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h6 class="mb-0 text-warning-dark text-nowrap">Mobile App</h6>
                                        </td>
                                        <td>
                                            <span class="badge text-light-success f-s-9 f-w-700">Completed</span>
                                        </td>
                                        <td class="f-w-600 text-dark">
                                            <a class="h-30 w-30 d-flex-center b-r-50 overflow-hidden text-bg-secondary m-auto"
                                                data-bs-title="Jane Smith" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/3.png')); ?>">
                                            </a>
                                        </td>
                                        <td class="text-secondary-dark f-w-600">
                                            Medium
                                        </td>
                                        <td>
                                            <span class="text-dark f-s-14 f-w-500 text-nowrap"><i
                                                    class="ti ti-circle-filled me-2 f-s-6"></i> Project
                                                deployed successfully</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h6 class="mb-0 text-danger-dark text-nowrap">
                                                Campaign</h6>
                                        </td>
                                        <td>
                                            <span class="badge text-light-secondary f-s-9 f-w-700">Not
                                                Started</span>
                                        </td>
                                        <td class="f-w-600 text-dark">
                                            <a class="h-30 w-30 d-flex-center b-r-50 overflow-hidden text-bg-secondary m-auto"
                                                data-bs-title="Mark Lee" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/4.png')); ?>">
                                            </a>
                                        </td>
                                        <td class="text-danger-dark f-w-600">
                                            Low
                                        </td>
                                        <td>
                                            <span class="text-dark f-s-14 f-w-500 text-nowrap"><i
                                                    class="ti ti-circle-filled me-2 f-s-6"></i> Campaign to
                                                begin in December</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h6 class="mb-0 text-primary-dark text-nowrap">E-Commerce</h6>
                                        </td>
                                        <td>
                                            <span class="badge text-light-warning f-s-9 f-w-700">In
                                                Progress</span>
                                        </td>
                                        <td class="f-w-600 text-dark">
                                            <a class="h-30 w-30 d-flex-center b-r-50 overflow-hidden text-bg-secondary m-auto"
                                                data-bs-title="Alice Johnson" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/5.png')); ?>">
                                            </a>
                                        </td>
                                        <td class="text-success-dark f-w-600">
                                            High
                                        </td>
                                        <td>
                                            <span class="text-dark f-s-14 f-w-500 text-nowrap"><i
                                                    class="ti ti-circle-filled me-2 f-s-6"></i> Initial
                                                setup </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h6 class="mb-0 text-success-dark text-nowrap">Social Media
                                            </h6>
                                        </td>
                                        <td>
                                            <span class="badge text-light-success f-s-9 f-w-700">Completed</span>
                                        </td>
                                        <td class="f-w-600 text-dark">
                                            <a class="h-30 w-30 d-flex-center b-r-50 overflow-hidden text-bg-secondary m-auto"
                                                data-bs-title="Sophia Green" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/4.png')); ?>">
                                            </a>
                                        </td>
                                        <td class="text-danger-dark f-w-600">
                                            Low
                                        </td>
                                        <td>
                                            <span class="text-dark f-s-14 f-w-500 text-nowrap">
                                                <i class="ti ti-circle-filled me-2 f-s-6"></i> Campaign
                                                launched successfully
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h6 class="mb-0 text-success-dark text-nowrap">SEO Optimization
                                            </h6>
                                        </td>
                                        <td>
                                            <span class="badge text-light-warning f-s-9 f-w-700">In
                                                Progress</span>
                                        </td>
                                        <td class="f-w-600 text-dark">
                                            <a class="h-30 w-30 d-flex-center b-r-50 overflow-hidden text-bg-secondary m-auto"
                                                data-bs-title="Liam Carter" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/5.png')); ?>">
                                            </a>
                                        </td>
                                        <td class="text-success-dark f-w-600">
                                            Medium
                                        </td>
                                        <td>
                                            <span class="text-dark f-s-14 f-w-500 text-nowrap">
                                                <i class="ti ti-circle-filled me-2 f-s-6"></i> Keyword
                                                analysis ongoing
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <h6 class="mb-0 text-success-dark text-nowrap">UI/UX Revamp</h6>
                                        </td>
                                        <td>
                                            <span class="badge text-light-info f-s-9 f-w-700">Scheduled</span>
                                        </td>
                                        <td class="f-w-600 text-dark">
                                            <a class="h-30 w-30 d-flex-center b-r-50 overflow-hidden text-bg-secondary m-auto"
                                                data-bs-title="Olivia Brown" data-bs-toggle="tooltip">
                                                <img alt="avtar" class="img-fluid"
                                                    src="<?php echo e(asset('assets/images/avtar/6.png')); ?>">
                                            </a>
                                        </td>
                                        <td class="text-danger-dark f-w-600">
                                            Low
                                        </td>
                                        <td>
                                            <span class="text-dark f-s-14 f-w-500 text-nowrap">
                                                <i class="ti ti-circle-filled me-2 f-s-6"></i> Resources
                                                allocated
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="table-footer ">
                    <p class="mb-0 f-s-15 f-w-500 txt-ellipsis-1">Showing 7 to 20 of 20 entries</p>
                    <ul class="pagination app-pagination justify-content-end ">
                        <li class="page-item disabled"><a class="page-link b-r-left" href="#">Previous</a>
                        </li>
                        <li class="page-item"><a class="page-link" href="#">1</a></li>
                        <li class="page-item active"><a class="page-link" href="#">2</a></li>
                        <li class="page-item"><a class="page-link" href="#">3</a></li>
                        <li class="page-item"><a class="page-link" href="#">Next</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-md-6 col-lg-5 col-xxl-3">
                <div class="p-3">
                    <h5>Today Tasks</h5>
                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="task-container slider">
                            <div class="card task-card bg-danger-300">
                                <div class="card-body">
                                    <h6 class="text-danger-dark txt-ellipsis-1">Finalize Project
                                        Proposal</h6>

                                    <ul class="avatar-group justify-content-start my-3">
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-primary">
                                            <img alt="avtar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/4.png')); ?>">
                                        </li>
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-success"
                                            data-bs-title="Lennon Briggs" data-bs-toggle="tooltip">
                                            <img alt="avtar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/5.png')); ?>">
                                        </li>
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-danger"
                                            data-bs-title="Maya Horton" data-bs-toggle="tooltip">
                                            <img alt="avtar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/6.png')); ?>">
                                        </li>
                                    </ul>

                                    <div class="d-flex justify-content-between align-items-center">
                                        <div aria-valuemax="100" aria-valuemin="0" aria-valuenow="25" class="progress w-100"
                                            role="progressbar">
                                            <div class="progress-bar bg-danger-dark progress-bar-striped progress-bar-animated"
                                                style="width: 68%"></div>
                                        </div>
                                        <span class="badge bg-white-300 text-danger-dark ms-2 ">+ 68%</span>
                                    </div>


                                </div>
                            </div>

                            <div class="card">
                                <div class="d-flex justify-content-between align-items-center rounded p-1 bg-primary-300">
                                    <span class="bg-primary h-35 w-35 d-flex-center rounded">
                                        <i class="iconoir-group f-s-18"></i>
                                    </span>
                                    <h6 class="mb-0 txt-ellipsis-1">Meeting</h6>
                                    <div class="d-flex gap-2">
                                        <span class="w-35 h-35 bg-white-300 text-info-dark rounded p-2 d-flex-center"><i
                                                class="iconoir-more-horiz f-s-18"></i>
                                        </span>
                                        <span class="w-35 h-35 bg-white-300 text-info-dark rounded p-2 d-flex-center"><i
                                                class="iconoir-copy f-s-18"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="card task-card bg-warning-300">
                                <div class="card-body">
                                    <h6 class="text-warning-dark txt-ellipsis-1">Design Homepage Layout</h6>
                                    <ul class="avatar-group justify-content-start my-3">
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-primary">
                                            <img alt="avtar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/3.png')); ?>">
                                        </li>
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-info"
                                            data-bs-title="Sophia Turner" data-bs-toggle="tooltip">
                                            <img alt="avtar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/7.png')); ?>">
                                        </li>
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-warning"
                                            data-bs-title="Lucas Green" data-bs-toggle="tooltip">
                                            <img alt="avtar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/8.png')); ?>">
                                        </li>
                                    </ul>

                                    <div class="d-flex justify-content-between align-items-center">
                                        <div aria-valuemax="100" aria-valuemin="0" aria-valuenow="25" class="progress w-100"
                                            role="progressbar">
                                            <div class="progress-bar bg-warning-dark progress-bar-striped progress-bar-animated"
                                                style="width: 35%"></div>
                                        </div>

                                        <span class="badge bg-white-400 text-secondary-dark ms-2">+
                                            35%</span>
                                    </div>
                                </div>

                            </div>

                            <div class="card">
                                <div class="d-flex justify-content-between align-items-center rounded p-1 bg-info-300">
                                    <span class="bg-info h-35 w-35 d-flex-center rounded">
                                        <i class="iconoir-group f-s-18"></i>
                                    </span>
                                    <h6 class="mb-0 txt-ellipsis-1">Meeting</h6>
                                    <div class="d-flex gap-2">
                                        <span class="w-35 h-35 bg-white-300 text-info-dark rounded p-2 d-flex-center"><i
                                                class="iconoir-more-horiz f-s-18"></i>
                                        </span>
                                        <span class="w-35 h-35 bg-white-300 text-info-dark rounded p-2 d-flex-center"><i
                                                class="iconoir-copy f-s-18"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="d-flex justify-content-between align-items-center rounded p-1 bg-success-300">
                                    <span class="bg-success h-35 w-35 d-flex-center rounded">
                                        <i class="iconoir-group f-s-18"></i>
                                    </span>
                                    <h6 class="mb-0 txt-ellipsis-1">Meeting</h6>
                                    <div class="d-flex gap-2">
                                        <span class="w-35 h-35 bg-white-300 text-info-dark rounded p-2 d-flex-center"><i
                                                class="iconoir-more-horiz f-s-18"></i>
                                        </span>
                                        <span class="w-35 h-35 bg-white-300 text-info-dark rounded p-2 d-flex-center"><i
                                                class="iconoir-copy f-s-18"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="card task-card bg-info-300">
                                <div class="card-body">
                                    <h6 class="text-info-dark txt-ellipsis-1">Develop API Integration</h6>
                                    <ul class="avatar-group justify-content-start my-3">
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-info">
                                            <img alt="avatar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/4.png')); ?>">
                                        </li>
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-info"
                                            data-bs-title="Michael Johnson" data-bs-toggle="tooltip">
                                            <img alt="avatar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/6.png')); ?>">
                                        </li>
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-warning"
                                            data-bs-title="Emily Brown" data-bs-toggle="tooltip">
                                            <img alt="avatar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/5.png')); ?>">
                                        </li>
                                    </ul>

                                    <div class="d-flex justify-content-between align-items-center">
                                        <div aria-valuemax="100" aria-valuemin="0" aria-valuenow="60" class="progress w-100"
                                            role="progressbar">
                                            <div class="progress-bar bg-info-dark progress-bar-striped progress-bar-animated"
                                                style="width: 60%"></div>
                                        </div>
                                        <span class="badge bg-white-400 text-secondary-dark ms-2">+
                                            60%</span>
                                    </div>
                                </div>
                            </div>

                            <div class="card task-card bg-success-300">
                                <div class="card-body">
                                    <h6 class="text-success-dark txt-ellipsis-1">Test User Feedback</h6>
                                    <ul class="avatar-group justify-content-start my-3">
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-primary">
                                            <img alt="avatar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/9.png')); ?>">
                                        </li>
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-info"
                                            data-bs-title="Alice Smith" data-bs-toggle="tooltip">
                                            <img alt="avatar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/10.png')); ?>">
                                        </li>
                                        <li class="h-35 w-35 d-flex-center b-r-50 overflow-hidden bg-success"
                                            data-bs-title="John Doe" data-bs-toggle="tooltip">
                                            <img alt="avatar" class="img-fluid"
                                                src="<?php echo e(asset('assets/images/avtar/11.png')); ?>">
                                        </li>
                                    </ul>

                                    <div class="d-flex justify-content-between align-items-center">
                                        <div aria-valuemax="100" aria-valuemin="0" aria-valuenow="80" class="progress w-100"
                                            role="progressbar">
                                            <div class="progress-bar bg-success-dark progress-bar-striped progress-bar-animated"
                                                style="width: 80%"></div>
                                        </div>
                                        <span class="badge bg-white-400 text-secondary-dark ms-2">+
                                            80%</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


<?php $__env->stopSection(); ?>

<!-- Notification Channel Modal -->
<!-- Channel Breakdown Modal -->
<div class="modal fade" id="channelModal" tabindex="-1" aria-labelledby="channelModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="channelModalLabel">Channel Breakdown</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">

                <div class="row mb-3">
                    <div class="col-md-4">
                        <select class="form-select" id="channelStatusFilter">
                            <option value="">All Statuses</option>
                            <option value="pending">Pending</option>
                            <option value="sent">Sent</option>
                            <option value="failed">Failed</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <input type="text" class="form-control" id="channelSearchInput"
                            placeholder="Search message or title">
                    </div>
                    <div class="col-md-4 text-end">
                        <button class="btn btn-sm btn-outline-primary" id="exportBtn">Export</button>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Title</th>
                                <th>Message</th>
                                <th>Channel</th>
                                <th>Status</th>
                                <th>Scheduled At</th>
                                <th>Created At</th>
                            </tr>
                        </thead>
                        <tbody id="channelTableBody"></tbody>
                    </table>
                </div>
                <nav>
                    <ul class="pagination justify-content-center" id="channelPagination"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>

<div class="modal" data-bs-backdrop="static" id="welcomeCard" tabindex="-1">
<div class="modal-dialog modal-dialog-centered">
    <div class="modal-content welcome-card">

        <div class="modal-body p-0">
            <div class="text-center position-relative welcome-card-content z-1 p-3">
                <div class="text-end position-relative z-1">
                    <i class="ti ti-x fs-5 text-dark f-w-600" data-bs-dismiss="modal"></i>
                </div>
                <h2 class="f-w-700 text-primary-dark mb-0"><span>Welcome!</span> <img alt="gif"
                        class="w-45 d-inline align-baseline"
                        src="<?php echo e(asset('assets/images/dashboard/ecommerce-dashboard/celebration.gif')); ?>">
                </h2>

                <div class="modal-img-box">
                    <img alt="img" class=" img-fluid" src="<?php echo e(asset('assets/images/modals/welcome-1.png')); ?>">
                </div>
                <div class="modal-btn mb-4">
                    <button class="btn btn-primary text-white btn-sm rounded" data-bs-dismiss="modal" type="button">
                        Get Started
                    </button>
                </div>
            </div>

        </div>
    </div>
</div>
</div>


<?php $__env->startSection('scripts'); ?>

    <script>
        // Make sure this is in global scope
        function loadChannelData(channel, page = 1) {
            // Get modal instance
            const modalEl = document.getElementById('channelModal');
            const modal = bootstrap.Modal.getOrCreateInstance(modalEl);

            // Update modal title
            document.getElementById('channelModalLabel').textContent = `Channel Breakdown: ${channel.toUpperCase()}`;

            // Store current channel for filter/search usage
            window.currentChannel = channel;

            // Prepare fetch URL and params (default no filter/search for initial load)
            const params = new URLSearchParams({
                channel: channel,
                page: page,
                status: document.getElementById('channelStatusFilter').value || '',
                search: document.getElementById('channelSearchInput').value.trim() || '',
            });

            fetch(`<?php echo e(route('admin.notifications.channel-data')); ?>?${params.toString()}`)
                .then(res => res.json())
                .then(data => {
                    // Fill table body
                    document.getElementById('channelTableBody').innerHTML = data.tableRows;
                    // Fill pagination
                    document.getElementById('channelPagination').innerHTML = data.pagination;

                    // Add click to pagination links
                    document.querySelectorAll('#channelPagination a.page-link').forEach(link => {
                        link.addEventListener('click', e => {
                            e.preventDefault();
                            const pageNum = link.getAttribute('data-page');
                            if (pageNum) loadChannelData(channel, pageNum);
                        });
                    });

                    // Show modal
                    modal.show();
                })
                .catch(err => console.error(err));
        }
        document.addEventListener('DOMContentLoaded', () => {
            const modal = new bootstrap.Modal(document.getElementById('channelModal'));
            const modalTitle = document.getElementById('channelModalLabel');
            const statusFilter = document.getElementById('channelStatusFilter');
            const searchInput = document.getElementById('channelSearchInput');
            const exportBtn = document.getElementById('exportBtn');
            const tableBody = document.getElementById('channelTableBody');
            const pagination = document.getElementById('channelPagination');

            const smsBarWrapper = document.getElementById('smsBarWrapper');
            const emailBarWrapper = document.getElementById('emailBarWrapper');
            const ivrBarWrapper = document.getElementById('ivrBarWrapper');

            const smsCount = document.getElementById('smsCount');
            const emailCount = document.getElementById('emailCount');
            const ivrCount = document.getElementById('ivrCount');

            let currentChannel = null;
            let currentPage = 1;
            let searchTimeout = null;

            // Load chart/summary stats
            function loadNotificationStats() {
                fetch("<?php echo e(route('admin.dashboard.notification-stats')); ?>")
                    .then(res => res.json())
                    .then(data => {
                        const smsTotal = data.sms.total || 0;
                        const emailTotal = data.email.total || 0;
                        const ivrTotal = data.ivr.total || 0;
                        const total = smsTotal + emailTotal + ivrTotal || 1;

                        smsBarWrapper.style.width = (smsTotal / total * 100) + '%';
                        emailBarWrapper.style.width = (emailTotal / total * 100) + '%';
                        ivrBarWrapper.style.width = (ivrTotal / total * 100) + '%';

                        smsCount.textContent = `SMS (${smsTotal})`;
                        emailCount.textContent = `Email (${emailTotal})`;
                        ivrCount.textContent = `IVR (${ivrTotal})`;
                    });
            }

            // Load modal table data
            function loadChannelTable(channel, page = 1) {
                currentChannel = channel;
                currentPage = page;
                modalTitle.textContent = `Channel Breakdown: ${channel.toUpperCase()}`;

                const status = statusFilter.value;
                const search = searchInput.value.trim();

                const params = new URLSearchParams({
                    channel,
                    status,
                    search,
                    page
                });

                fetch(`<?php echo e(route('admin.notifications.channel-data')); ?>?${params.toString()}`)
                    .then(res => res.json())
                    .then(data => {
                        tableBody.innerHTML = data.tableRows || '<tr><td colspan="6" class="text-center">No results found</td></tr>';
                        pagination.innerHTML = data.pagination || '';

                        // Attach pagination click handlers
                        document.querySelectorAll('#channelPagination a.page-link').forEach(link => {
                            link.addEventListener('click', (e) => {
                                e.preventDefault();
                                const pageNum = link.getAttribute('data-page');
                                if (pageNum) loadChannelTable(channel, parseInt(pageNum));
                            });
                        });
                    });

                modal.show();
            }

            // Debounced search handler
            searchInput.addEventListener('input', () => {
                clearTimeout(searchTimeout);
                searchTimeout = setTimeout(() => {
                    if (currentChannel) loadChannelTable(currentChannel, 1);
                }, 300);
            });

            // Filter change handler
            statusFilter.addEventListener('change', () => {
                if (currentChannel) loadChannelTable(currentChannel, 1);
            });

            // Export button
            exportBtn.addEventListener('click', () => {
                if (!currentChannel) return alert('Please open a channel first.');

                const params = new URLSearchParams({
                    channel: currentChannel,
                    status: statusFilter.value,
                    search: searchInput.value.trim()
                });

                window.open(`<?php echo e(route('admin.notifications.export')); ?>?${params.toString()}`, '_blank');
            });

            // Bar click bindings
            smsBarWrapper.addEventListener('click', () => loadChannelTable('sms'));
            emailBarWrapper.addEventListener('click', () => loadChannelTable('email'));
            ivrBarWrapper.addEventListener('click', () => loadChannelTable('ivr'));

            loadNotificationStats();
            setInterval(loadNotificationStats, 60000);
        });
    </script>































<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Addisalem.Hailu Files\xampp\htdocs\NISCIO_Notification_System\resources\views/admin/dashboard/index.blade.php ENDPATH**/ ?>