<?php $__env->startSection('title', 'All Notifications'); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/vendor/datatable/jquery.dataTables.min.css')); ?>">

    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
    <style>
        .glassmorph {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            border: 1px solid rgba(255, 255, 255, 0.25);
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.1);
        }

        .glass-modal {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(12px);
            border-radius: 1rem;
            border: 1px solid rgba(200, 200, 200, 0.2);
        }

        #modalSpinnerOverlay {
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background-color: rgba(255,255,255,0.7);
            z-index: 1055;
            display: flex;
            align-items: center;
            justify-content: center;
            }

    </style>


<?php $__env->stopSection(); ?>




<?php $__env->startSection('main_content'); ?>

    <div class="container-fluid">
        <!-- Breadcrumb start -->
        <div class="row m-1">
            <div class="col-12 ">
                <h4 class="main-title">All Notifications</h4>
                <ul class="app-line-breadcrumbs mb-3">
                    <li class="">
                        <a href="#" class="f-s-14 f-w-500">
                            <span>
                                <i class="ph-duotone  ph-table f-s-16"></i> Notifications
                            </span>
                        </a>
                    </li>
                    <li class="active">
                        <a href="#" class="f-s-14 f-w-500">All Notifications</a>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Breadcrumb end -->

        <!-- Data Table start -->
        <div class="row">
            <!-- Default Datatable start -->
            <div class="col-12">
                <div class="card ">
                    <div class="card-header">
                        <h5>All Notifications</h5>
                        <p> Ideal for managing SMS, Email, and IVR logs efficiently, with full support for status filtering
                            and export options</code>. </p>
                    </div>
                    <div class="card-body p-0">

                        <div class="app-datatable-default overflow-auto">



                            <div class="table-responsive">
                            <div class="row mt-4 mb-3 align-items-end">
                                <!-- Channel Filter -->
                                <div class="col-md-3">
                                    <label for="filterChannel" class="form-label fw-semibold">Channel</label>
                                    <select id="filterChannel" class="form-select form-select-sm">
                                        <option value="">All Channels</option>
                                        <option value="sms">SMS</option>
                                        <option value="email">Email</option>
                                        <option value="ivr">IVR</option>
                                    </select>
                                </div>

                                <!-- Status Filter -->
                                <div class="col-md-3">
                                    <label for="filterStatus" class="form-label fw-semibold">Status</label>
                                    <select id="filterStatus" class="form-select form-select-sm">
                                        <option value="">All Statuses</option>
                                        <option value="pending">Pending</option>
                                        <option value="sent">Sent</option>
                                        <option value="failed">Failed</option>
                                    </select>
                                </div>

                                <!-- Customer Name Search -->
                                <div class="col-md-3">
                                    <label for="filterCustomerName" class="form-label fw-semibold">Customer Name</label>
                                    <input type="text" id="filterCustomerName" class="form-control form-control-sm"
                                        placeholder="e.g. Metsehafe Ezra">
                                </div>

                                <!-- Title Search -->
                                <div class="col-md-3">
                                    <label for="filterTitle" class="form-label fw-semibold">Notification Title</label>
                                    <input type="text" id="filterTitle" class="form-control form-control-sm"
                                        placeholder="e.g. Policy Expiry Reminder">
                                </div>
                            </div>


                                <table id="notificationsTable" class="table table-bordered table-striped w-100">
                                    <thead>
                                        <tr>
                                            <th>#</th> <!-- id -->
                                            <th>Customer</th> <!-- customer name with initials -->
                                            <th>Title</th> <!-- notification title -->
                                            <th>Message</th> <!-- notification message -->
                                            <th>Channel</th> <!-- sms/email/ivr -->
                                            <th>Status</th> <!-- pending/sent/failed -->
                                            <th>Scheduled At</th> <!-- scheduled_at -->
                                            <th>Created At</th> <!-- created_at -->
                                            <th>Actions</th> <!-- button for modal/view -->
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Child rows example and -->
        </div>
        <!-- Data Table end -->
    </div>

<!-- Fancy AJAX Modal -->
<!-- Modal Container -->
<div class="modal fade" id="notificationModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content glassmorph">
      <div class="modal-header">
        <h5 class="modal-title">Notification Detail</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" id="notificationModalBody">
        <div class="text-center py-5">
          <div class="spinner-border text-primary" role="status"></div>
          <p class="mt-3">Loading notification details...</p>
        </div>
      </div>
    </div>
  </div>
</div>


<div class="modal fade" id="sendNotifModal" tabindex="-1" aria-labelledby="sendNotifLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content glassmorph">
      <div class="modal-header">
        <h5 class="modal-title" id="sendNotifLabel">Send Notification</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <form method="POST" action="<?php echo e(route('admin.notifications.send')); ?>" id="sendNotificationForm">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="notification_id" id="modalNotificationId" value="">
        <input type="hidden" name="phone_number" id="modalPhoneNumber" value="">
        <input type="hidden" name="email" id="modalEmail" value="">

        <div class="modal-body">

        <div id="modalSpinnerOverlay" class="d-none">
  <div class="spinner-border text-primary" role="status">
    <span class="visually-hidden">Loading...</span>
  </div>
</div>
          <ul class="nav nav-tabs mb-3" role="tablist">
            <?php $__currentLoopData = ['sms' => 'SMS', 'email' => 'Email', 'ivr' => 'IVR']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li class="nav-item">
                <a class="nav-link <?php if($loop->first): ?> active <?php endif; ?>" data-bs-toggle="tab" href="#tab-<?php echo e($key); ?>"><?php echo e($label); ?></a>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>

          <div class="tab-content">
            
            <div class="tab-pane fade show active" id="tab-sms">
              <div class="mb-2 form-check">
                <input type="checkbox" class="form-check-input" name="channels[]" value="sms" id="sendSMSCheck">
                <label class="form-check-label fw-semibold" for="sendSMSCheck">Send via SMS</label>
              </div>
              <textarea name="sms_message" id="smsMessage" class="form-control" rows="3" readonly value=""></textarea>
            </div>

            
            <div class="tab-pane fade" id="tab-email">
              <div class="mb-2 form-check">
                <input type="checkbox" class="form-check-input" name="channels[]" value="email" id="sendEmailCheck">
                <label class="form-check-label fw-semibold" for="sendEmailCheck">Send via Email</label>
              </div>
              <textarea name="email_message" id="emailMessage" class="form-control" rows="4" readonly value=""></textarea>
            </div>

            
            <div class="tab-pane fade" id="tab-ivr">
              <div class="mb-2 form-check">
                <input type="checkbox" class="form-check-input" name="channels[]" value="ivr" id="sendIVRCheck">
                <label class="form-check-label fw-semibold" for="sendIVRCheck">Send via IVR</label>
              </div>
              <textarea name="ivr_script" id="ivrMessage" class="form-control" rows="3" readonly value=""></textarea>
            </div>
          </div>
        </div>

        <div class="modal-footer">
          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Send Now</button>
        </div>
      </form>
    </div>
  </div>
</div>

<div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 1100">
  <div id="notifToast" class="toast align-items-center text-bg-danger border-0" role="alert">
    <div class="d-flex">
      <div class="toast-body" id="notifToastMsg">Error occurred</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
    </div>
  </div>
</div>


<?php $__env->stopSection(); ?>




<?php $__env->startSection('scripts'); ?>


    <script src="<?php echo e(asset('assets/js/jquery-3.6.3.min.js')); ?>"></script>

    <!-- Bootstrap js-->
    <script src="<?php echo e(asset('assets/vendor/bootstrap/bootstrap.bundle.min.js')); ?>"></script>

    <!-- Simple bar js-->
    <script src="<?php echo e(asset('assets/vendor/simplebar/simplebar.js')); ?>"></script>

    <!-- phosphor js -->
    <script src="<?php echo e(asset('assets/vendor/phosphor/phosphor.js')); ?>"></script>

    <!-- Customizer js-->
    <script src="<?php echo e(asset('assets/js/customizer.js')); ?>"></script>

    <!-- prism js-->
    <script src="<?php echo e(asset('assets/vendor/prism/prism.min.js')); ?>"></script>

    <!-- App js-->
    <script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>

    <!--customizer-->
    <div id="customizer"></div>

    <!-- data table js -->
    <script src="<?php echo e(asset('assets/vendor/datatable/jquery.dataTables.min.js')); ?>"></script>

    <!-- js-->
    <script src="<?php echo e(asset('assets/js/data_table.js')); ?>"></script>
    <!-- scripts end-->

    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.0/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.3.0/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>



    <script>
        $(document).ready(function () {
            const table = $('#notificationsTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '<?php echo e(route("admin.notifications.index")); ?>',
                    data: function (d) {
    d.channel = $('#filterChannel').val();
    d.status = $('#filterStatus').val();
    d.customer_name = $('#filterCustomerName').val();
    d.title = $('#filterTitle').val();
}
                },
                columns: [
                    { data: 'id' },
                    { data: 'customer' }, // moved to 2nd position
                    { data: 'title' },
                    { data: 'message', render: msg => msg.length > 50 ? msg.substring(0, 50) + '...' : msg },
                    { data: 'channel', render: d => `<span class="badge bg-${getChannelColor(d)} text-uppercase">${d}</span>` },
                    { data: 'status', render: d => `<span class="badge bg-${getStatusColor(d)} text-capitalize">${d}</span>` },
                    { data: 'scheduled_at' },
                    { data: 'created_at' },
                    { data: 'actions' }
                ],


                dom: `<"row mb-2"
                    <"col-md-6 d-flex align-items-center"l>
                    <"col-md-6 text-end"B>
                >rt
                <"row"
                    <"col-sm-12 col-md-5"i>
                    <"col-sm-12 col-md-7"p>
                >`,
                buttons: [
                    {
                        extend: 'csvHtml5',
                        text: '<i class="ti ti-file-type-csv text-success me-1"></i> CSV',
                        className: 'btn btn-sm btn-outline-success'
                    },
                    {
                        extend: 'excelHtml5',
                        text: '<i class="ti ti-file-spreadsheet text-primary me-1"></i> Excel',
                        className: 'btn btn-sm btn-outline-primary'
                    },
                    {
                        extend: 'pdfHtml5',
                        text: '<i class="ti ti-file-text text-danger me-1"></i> PDF',
                        className: 'btn btn-sm btn-outline-danger',
                        orientation: 'landscape',
                        pageSize: 'A4'
                    },
                    {
                        extend: 'print',
                        text: '<i class="ti ti-printer text-dark me-1"></i> Print',
                        className: 'btn btn-sm btn-outline-dark'
                    }
                ]
            });


            $('#filterChannel, #filterStatus').on('change', function () {
    table.ajax.reload();
});

// Trigger reload on typing in text inputs with delay
let searchTimeout;
$('#filterCustomerName, #filterTitle').on('input', function () {
    clearTimeout(searchTimeout);
    searchTimeout = setTimeout(() => {
        table.ajax.reload();
    }, 300); // delay typing for 300ms
});


            function getChannelColor(channel) {
                return {
                    sms: 'badge text-light-success',
                    email: 'badge text-light-primary',
                    ivr: 'badge text-light-warning'
                }[channel] || 'secondary';
            }

            function getStatusColor(status) {
                return {
                    sent: 'badge text-light-success',
                    pending: 'badge text-light-info',
                    failed: 'badge text-light-danger'
                }[status] || 'badge text-light-secondary';
            }
        });
    </script>

<script>
$(document).on('click', '.openNotificationModal', function () {
    const id = $(this).data('id');
    $('#notificationModal').modal('show');
    $('#notificationModalBody').html(`
        <div class="text-center py-5">
          <div class="spinner-border text-primary" role="status"></div>
          <p class="mt-3">Loading notification details...</p>
        </div>
    `);

    $.get(`/admin/notifications/${id}`, function (data) {
        $('#notificationModalBody').html(data);
    }).fail(function () {
        $('#notificationModalBody').html(`<p class="text-danger text-center">Failed to load notification details.</p>`);
    });
});


toastr.options = {
  closeButton: true,
  progressBar: true,
  timeOut: 4000,
  positionClass: 'toast-top-right',
};
$(document).ready(function () {


  $('#sendNotificationBtn').on('click', function () {

    const notifId = $(this).data('id');

    const $modal = $('#sendNotifModal');
   // $('#modalNotificationId').val(notifId);

    $modal.modal('show');
    $('#modalSpinnerOverlay').removeClass('d-none');

    $.ajax({
      url: `/admin/notifications/view/${notifId}`,
      type: 'GET',
      dataType: 'json',
      success: function (data) {
        $('#modalNotificationId').val(data.id);
        $('#modalPhoneNumber').val(data.customer?.phone_number ?? '');
        $('#modalEmail').val(data.customer?.email ?? '');
        $('#smsMessage').val(data.message ?? '');
        $('#emailMessage').val(data.message ?? '');
        $('#ivrMessage').val(data.message ?? '');

        // Reset tabs
        $('#sendNotifModal .nav-tabs .nav-link').removeClass('active');
        $('#sendNotifModal .nav-tabs .nav-link:first').addClass('active');
        $('#sendNotifModal .tab-pane').removeClass('show active');
        $('#sendNotifModal .tab-pane:first').addClass('show active');
      },
      error: function () {
        toastr.error('❌ Failed to load notification details.');
        $modal.modal('hide');
      },
      complete: function () {
        $('#modalSpinnerOverlay').addClass('d-none');
      }
    });
  });
});
</script>







<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/oriontje/frontend.oriontechet.com/resources/views/admin/notifications/index.blade.php ENDPATH**/ ?>