<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class IvrLog extends Model
{
    protected $fillable = [
        'notification_id',
        'phone_number',
        'ivr_script',
        'call_status',
        'duration',
        'response_details',
    ];

    protected $casts = [
        'response_details' => 'array',
    ];

    public function notification(): BelongsTo
    {
        return $this->belongsTo(Notification::class);
    }
}
