<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TemplateChangeLog extends Model
{
    protected $fillable = [
        'template_id',
        'user_id',
        'change_summary',
        'old_content',
        'new_content',
    ];

    protected $casts = [
        'old_content' => 'array',
        'new_content' => 'array',
    ];

    public function template(): BelongsTo
    {
        return $this->belongsTo(NotificationTemplate::class, 'template_id');
    }
}
