<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('audit_trails', function (Blueprint $table) {
            $table->id();
            $table->string('user_type')->nullable(); // admin, system, etc.
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('action'); // e.g., created, updated, deleted
            $table->string('auditable_type'); // model/class affected
            $table->unsignedBigInteger('auditable_id'); // record id affected
            $table->json('old_values')->nullable();
            $table->json('new_values')->nullable();
            $table->ipAddress('ip_address')->nullable();
            $table->string('user_agent')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('audit_trails');
    }
};
