@extends('layouts.master')

@section('title', 'Create Customers')

@section('css')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/quill.snow.css') }}">
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@1.6.2/dist/select2-bootstrap4.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.css" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />

</style>
<style>
  .highlight-card {
    background-color: rgba(255, 255, 255, 0.3);
    border: 1px solid rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(6px);
    -webkit-backdrop-filter: blur(6px);
    transition: all 0.4s ease;
  }
</style>

@endsection

@section('breadcrumb')
<div class="header-logo-wrapper col-auto">
  <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
        src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
        src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
</div>
<div class="col-4 col-xl-4 page-title">
  <h4 class="f-w-700">Create Customers</h4>
  <nav>
    <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
      <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
      <li class="breadcrumb-item f-w-400">Create</li>
      <li class="breadcrumb-item f-w-400 active">Customers</li>
    </ol>
  </nav>
</div>
@endsection

@section('main_content')
<!-- Container-fluid starts-->
<div class="container-fluid">
  <div class="row">
    <div class="col-md-12">
      <div class="card">
        <div class="card-header">
          <h4>Create new customer</h4>
          <p class="f-m-light mt-1">
            Please fill in this secure form to create a comprehensive client profile. Fields marked with * are required for policy compliance and underwriting purposes.</p>
        </div>
        <div class="card-body">
          <div class="vertical-main-wizard">
            <div class="row g-3">
              <form id="customerForm" class="row g-3 needs-validation custom-input">
                <div class="col-xxl-3 col-xl-4 col-12">
                  <div class="position-sticky top-0">
                    <div class="nav flex-column header-vertical-wizard" id="wizard-tab" role="tablist" aria-orientation="vertical">


                      <!-- Nav Tabs -->
                      <a class="nav-link active" id="personal-info-tab" data-bs-toggle="pill" href="#personal-info" role="tab"
                        aria-controls="personal-info" aria-selected="true" data-scroll-target="#card-personal-info">
                        <div class="vertical-wizard">
                          <div class="stroke-icon-wizard"><i class="fa fa-user"></i></div>
                          <div class="vertical-wizard-content">
                            <h6>Personal Info</h6>
                            <p>Full Name, Gender, DOB, ID</p>
                          </div>
                        </div>
                      </a>

                      <a class="nav-link" id="contact-info-tab" data-bs-toggle="pill" href="#contact-info" role="tab"
                        aria-controls="contact-info" aria-selected="false" data-scroll-target="#contact-info">
                        <div class="vertical-wizard">
                          <div class="stroke-icon-wizard"><i class="fa fa-envelope"></i></div>
                          <div class="vertical-wizard-content">
                            <h6>Contact Info</h6>
                            <p>Email, Phone, Address</p>
                          </div>
                        </div>
                      </a>

                      <a class="nav-link" id="employment-info-tab" data-bs-toggle="pill" href="#employment-info" role="tab"
                        aria-controls="employment-info" aria-selected="false" data-scroll-target="#employment-info">
                        <div class="vertical-wizard">
                          <div class="stroke-icon-wizard"><i class="fa fa-briefcase"></i></div>
                          <div class="vertical-wizard-content">
                            <h6>Employment Info</h6>
                            <p>Employer, Job Title</p>
                          </div>
                        </div>
                      </a>

                      <a class="nav-link" id="system-info-tab" data-bs-toggle="pill" href="#system-info" role="tab"
                        aria-controls="system-info" aria-selected="false" data-scroll-target="#system-info">
                        <div class="vertical-wizard">
                          <div class="stroke-icon-wizard"><i class="fa fa-cogs"></i></div>
                          <div class="vertical-wizard-content">
                            <h6>System Info</h6>
                            <p>Account status, login info</p>
                          </div>
                        </div>
                      </a>

                      <a class="nav-link" id="marketing-tab" data-bs-toggle="pill" href="#marketing" role="tab"
                        aria-controls="marketing" aria-selected="false" data-scroll-target="#marketing">
                        <div class="vertical-wizard">
                          <div class="stroke-icon-wizard"><i class="fa fa-bullhorn"></i></div>
                          <div class="vertical-wizard-content">
                            <h6>Marketing Prefs</h6>
                            <p>Consent & notifications</p>
                          </div>
                        </div>
                      </a>

                      <a class="nav-link" id="insurance-details-tab" data-bs-toggle="pill" href="#insurance-details" role="tab"
                        aria-controls="insurance-details" aria-selected="false" data-scroll-target="#insurance-details">
                        <div class="vertical-wizard">
                          <div class="stroke-icon-wizard"><i class="fa fa-shield"></i></div>
                          <div class="vertical-wizard-content">
                            <h6>Insurance Details</h6>
                            <p>Policy type, coverage</p>
                          </div>
                        </div>
                      </a>

                      <a class="nav-link" id="beneficiaries-tab" data-bs-toggle="pill" href="#beneficiaries" role="tab"
                        aria-controls="beneficiaries" aria-selected="false" data-scroll-target="#beneficiaries">
                        <div class="vertical-wizard">
                          <div class="stroke-icon-wizard"><i class="fa fa-users"></i></div>
                          <div class="vertical-wizard-content">
                            <h6>Beneficiaries</h6>
                            <p>People & allocations</p>
                          </div>
                        </div>
                      </a>

                      <a class="nav-link" id="risk-assessment-tab" data-bs-toggle="pill" href="#risk-assessment" role="tab"
                        aria-controls="risk-assessment" aria-selected="false" data-scroll-target="#risk-assessment">
                        <div class="vertical-wizard">
                          <div class="stroke-icon-wizard"><i class="fa fa-exclamation-triangle"></i></div>
                          <div class="vertical-wizard-content">
                            <h6>Risk Assessment</h6>
                            <p>Flags & scoring</p>
                          </div>
                        </div>
                      </a>

                      <!-- Bottom Save Draft Button -->

                      <div class="p-2 border-bottom bg-white">
                        <button type="submit" id="submitBtn" class="btn btn-primary w-100">
                          <i class="fa fa-paper-plane me-1"></i> Submit
                        </button>
                      </div>


                      <div class="p-2 border-top bg-white">
                        <button type="button" class="btn btn-secondary w-100">
                          <i class="fa fa-save me-1"></i> Save as Draft
                        </button>
                      </div>


                    </div>
                  </div>
                </div>

                <div class="col-xxl-9 col-xl-8 col-12">
                  <div class="tab-content" id="wizard-tabContent">
                    <div class="tab-content" id="wizard-tabContent">

                      {{-- PERSONAL INFORMATION --}}
                      <div class="" id="wizard-personal" role="tabpanel" aria-labelledby="wizard-personal-tab">
                        <div class="col-sm-12 col-xl-12">
                          <div class="card shadow-none border" id="card-personal-info">
                            <div class="card-header">
                              <h4>Basic Customer Information</h4>
                            </div>
                            <div class="card-body row g-3">

                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="first_name">First Name <span class="txt-danger">*</span></label>
                                <input class="form-control" id="first_name" type="text" placeholder="Enter first name">
                                
                              </div>

                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="middle_name">Middle Name</label>
                                <input class="form-control" id="middle_name" type="text" placeholder="Enter middle name">
                                
                              </div>

                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="last_name">Last Name <span class="txt-danger">*</span></label>
                                <input class="form-control" id="last_name" type="text" placeholder="Enter last name">
                                
                              </div>

                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="gender">Gender <span class="txt-danger">*</span></label>
                                <select class="form-select" id="gender">
                                  <option selected disabled value="">Choose...</option>
                                  <option value="male">Male</option>
                                  <option value="female">Female</option>

                                </select>
                                <div class="invalid-feedback">Please select gender.</div>
                              </div>

                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="date_of_birth">Date of Birth <span class="txt-danger">*</span></label>
                                <input class="form-control" id="date_of_birth" type="date">
                                <div class="invalid-feedback">Please provide a valid date.</div>
                              </div>

                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="place_of_birth">Place of Birth</label>
                                <select id="place_of_birth" name="place_of_birth" class="form-select select2-country">
                                  <option value="" disabled selected>Select Place of Birth</option>
                                  @foreach($countries as $country)
                                  <option value="{{ $country->id }}"
                                    data-flag="https://flagcdn.com/w20/{{ strtolower($country->flag) }}">
                                    {{ $country->name }}
                                  </option>
                                  @endforeach
                                </select>
                              </div>


                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="marital_status">Marital Status</label>
                                <select class="form-select" id="marital_status">
                                  <option selected disabled value="">Choose...</option>
                                  <option value="single">Single</option>
                                  <option value="married">Married</option>
                                  <option value="divorced">Divorced</option>
                                  <option value="widowed">Widowed</option>
                                </select>
                              </div>

                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="nationality">Nationality</label>
                                <input class="form-control" id="nationality" type="text" placeholder="Enter nationality">
                              </div>

                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="national_id">National ID</label>
                                <input class="form-control" id="national_id" type="text" placeholder="Enter national ID">
                              </div>

                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="passport_number">Passport Number</label>
                                <input class="form-control" id="passport_number" type="text" placeholder="Enter passport number">
                              </div>

                              <div class="col-xxl-4 col-sm-6">
                                <label class="form-label" for="tax_id">Tax ID</label>
                                <input class="form-control" id="tax_id" type="text" placeholder="Enter tax ID">
                              </div>

                            </div>
                          </div>
                        </div>
                      </div>


                      {{-- CONTACT INFORMATION --}}
                      <div class="" id="wizard-contact" role="tabpanel" aria-labelledby="wizard-contact-tab">

                        <div class="col-12">
                          <div class="card shadow-none border" id="contact-info">
                            <div class="card-header">
                              <h4>Contact Information</h4>
                            </div>
                            <div class="card-body row g-3">

                              <div class="col-md-6">
                                <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" id="email" placeholder="Enter email">
                                <div class="invalid-feedback">Please provide a valid email.</div>
                              </div>

                              <div class="col-md-6">
                                <label for="phone" class="form-label">Phone <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control ethiopian-phone" id="phone" name="phone" placeholder="+251 9XX XXX XXX">
                                <div class="invalid-feedback">Please provide a valid phone number.</div>
                              </div>

                              <div class="col-md-6">
                                <label for="alt_phone" class="form-label">Alternate Phone</label>
                                <input type="tel" class="form-control ethiopian-phone" id="alt_phone" name="alt_phone" placeholder="+251 9XX XXX XXX">
                              </div>
                              <div class="col-md-6">
                                <label for="country" class="form-label">Country</label>
                                <select id="country" name="country" class="form-select select2-country">
                                  <option value="" disabled selected>Select Country</option>
                                  @foreach($countries as $country)
                                  <option value="{{ $country->id }}" data-flag="https://flagcdn.com/w20/{{ strtolower($country->flag) }}">
                                    {{ $country->name }}
                                  </option>
                                  @endforeach
                                </select>
                              </div>

                              <div class="col-md-4 position-relative">
                                <label for="region" class="form-label">Administrative Region/City</label>

                                <select id="region" name="region" class="form-select pe-5 select2" disabled>
                                  <option value="" disabled selected>Select administrative region/city</option>
                                </select>

                                <!-- Spinner Overlay -->
                                <div id="region-spinner" class="spinner-border text-primary position-absolute end-0 top-50 translate-middle-y d-none"
                                  style="width: 1rem; height: 1rem;" role="status">
                                  <span class="visually-hidden">Loading...</span>
                                </div>

                                <!-- Error Alert -->
                                <div id="region-error" class="alert alert-danger alert-dismissible fade show d-none mt-2" role="alert">
                                  <span id="region-error-message">Failed to load administrative region or city. Please try again.</span>
                                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>

                                <div id="region-error" class="alert alert-danger alert-dismissible fade show d-none mt-2" role="alert">
                                  <span id="region-error-message"></span>
                                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                              </div>



                              <div class="col-md-4">
                                <label for="city" class="form-label">Sub city/Zone</label>
                                <select id="city" name="city" class="form-select select2">
                                  <option value="" disabled selected>Select sub city/zone</option>
                                </select>

                                <!-- Spinner -->
                                <div id="city-spinner" class="spinner-border text-primary position-absolute end-0 top-50 translate-middle-y d-none"
                                  style="width: 1rem; height: 1rem;" role="status">
                                  <span class="visually-hidden">Loading...</span>
                                </div>

                                <div id="city-error" class="alert alert-danger alert-dismissible fade show d-none mt-2" role="alert">
                                  <span id="city-error-message"></span>
                                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>

                                <!-- Error Alert -->
                                <div id="city-error" class="alert alert-danger alert-dismissible fade show d-none mt-2" role="alert">
                                  <span id="city-error-message">Failed to load sub city or zone. Please try again.</span>
                                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                              </div>

                              <div class="col-md-4 position-relative">
                                <label for="wereda" class="form-label">Wereda/Town</label>

                                <select id="wereda" name="wereda" class="form-select pe-5 select2" disabled>
                                  <option value="" disabled selected>Select Wereda/Town</option>
                                </select>

                                <!-- Spinner -->
                                <div id="wereda-spinner" class="spinner-border text-primary position-absolute end-0 top-50 translate-middle-y d-none"
                                  style="width: 1rem; height: 1rem;" role="status">
                                  <span class="visually-hidden">Loading...</span>
                                </div>
                                <div id="wereda-error" class="alert alert-danger alert-dismissible fade show d-none mt-2" role="alert">
                                  <span id="wereda-error-message"></span>
                                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>


                                <!-- Error Alert -->
                                <div id="wereda-error" class="alert alert-danger alert-dismissible fade show d-none mt-2" role="alert">
                                  <span id="wereda-error-message">Failed to load wereda or town. Please try again.</span>
                                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                              </div>





                              <div class="col-md-4">
                                <label for="postal_code" class="form-label">Kebele</label>
                                <input type="text" class="form-control" id="kebele" placeholder="Enter kebele">
                              </div>

                              <div class="col-md-4">
                                <label for="postal_code" class="form-label">House No.</label>
                                <input type="text" class="form-control" id="house_no" placeholder="Enter house no">
                              </div>



                              <div class="col-12">
                                <label for="address" class="form-label">Address</label>
                                <textarea class="form-control" id="address" rows="2" placeholder="Enter address"></textarea>
                              </div>

                              <div class="col-md-4">
                                <label for="postal_code" class="form-label">Postal Code</label>
                                <input type="text" class="form-control" id="postal_code" placeholder="Enter postal code">
                              </div>

                            </div>
                          </div>
                        </div>

                      </div>



                      {{-- EMPLOYMENT INFORMATION --}}
                      <div class="" id="wizard-employment" role="tabpanel" aria-labelledby="wizard-employment-tab">

                        <div class="col-12">
                          <div class="card shadow-none border" id="employment-info">
                            <div class="card-header">
                              <h4>Employment Information</h4>
                            </div>
                            <div class="card-body row g-3">

                              <div class="col-md-6">
                                <label for="occupation" class="form-label">Occupation</label>
                                <input type="text" class="form-control" id="occupation" placeholder="Enter occupation">
                              </div>

                              <div class="col-md-6">
                                <label for="employer_name" class="form-label">Employer Name</label>
                                <input type="text" class="form-control" id="employer_name" placeholder="Enter employer name">
                              </div>

                              <div class="col-12">
                                <label for="employer_address" class="form-label">Employer Address</label>
                                <textarea class="form-control" id="employer_address" rows="2" placeholder="Enter employer address"></textarea>
                              </div>

                              <div class="col-md-6">
                                <label for="employment_status" class="form-label">Employment Status</label>
                                <select class="form-select" id="employment_status" aria-label="Employment status">
                                  <option selected disabled value="">Choose...</option>
                                  <option>Employed</option>
                                  <option>Unemployed</option>
                                  <option>Self-employed</option>
                                  <option>Retired</option>
                                  <option>Student</option>
                                </select>
                              </div>

                              <div class="col-md-6">
                                <label for="annual_income" class="form-label">Annual Income</label>
                                <input type="number" step="0.01" class="form-control" id="annual_income" placeholder="Enter income">
                              </div>

                            </div>
                          </div>
                        </div>

                      </div>



                      {{-- SYSTEM/ACCOUNT INFORMATION --}}
                      <div class="" id="wizard-system" role="tabpanel" aria-labelledby="wizard-system-tab">

                        <div class="col-12">
                          <div class="card shadow-none border" id="system-info">
                            <div class="card-header">
                              <h4>System / Account Information</h4>
                            </div>
                            <div class="card-body row g-3">

                              <div class="col-md-6">
                                <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" id="email" placeholder="Enter email">
                                
                              </div>

                              <div class="col-md-6">
                                <label for="email_verified_at" class="form-label">Email Verified At</label>
                                <input type="datetime-local" class="form-control" id="email_verified_at">
                              </div>

                              <div class="col-md-6">
                                <label for="phone_verified_at" class="form-label">Phone Verified At</label>
                                <input type="datetime-local" class="form-control" id="phone_verified_at">
                              </div>

                              <div class="col-md-6">
                                <label for="customer_status" class="form-label">Customer Status</label>
                                <select class="form-select" id="customer_status" aria-label="Customer status">
                                  <option selected disabled value="">Choose...</option>
                                  <option value="active">Active</option>
                                  <option value="inactive">Inactive</option>
                                  <option value="blacklisted">Blacklisted</option>
                                </select>
                              </div>

                              <div class="col-md-6">
                                <label for="last_login_at" class="form-label">Last Login At</label>
                                <input type="datetime-local" class="form-control" id="last_login_at">
                              </div>

                              <div class="col-md-6">
                                <label for="source" class="form-label">Source</label>
                                <select name="source" id="source" class="form-select">
                                  <option value="" disabled selected>Select Source</option>
                                  <option value="walk-in">Walk-in</option>
                                  <option value="website">Website</option>
                                  <option value="agent">Agent</option>
                                  <option value="referral">Referral</option>
                                </select>
                              </div>


                              <div class="col-md-6">
                                <label for="profile_picture" class="form-label">Profile Picture</label>

                                <!-- Dropzone-style container -->
                                <div id="profilePictureDropzone" class="dropzone border rounded p-4 text-center position-relative">
                                  <div class="dz-preview dz-file-preview d-none">
                                    <div class="dz-image mb-2">
                                      <img id="profilePicturePreview" src="#" alt="Preview" style="max-width: 100px; border-radius: 8px;">
                                    </div>
                                    <button type="button" class="btn btn-sm btn-danger dz-remove">Remove</button>
                                  </div>

                                  <!-- Placeholder shown initially -->
                                  <div class="dz-message text-muted" id="profilePicturePlaceholder">
                                    <i class="bi bi-person-circle" style="font-size: 48px;"></i>
                                    <p class="mt-2 mb-0">Drag & drop or click to upload</p>
                                  </div>
                                </div>

                                <!-- Hidden file input that gets submitted with the form -->
                                <input type="file" name="profile_picture" id="profile_picture" class="d-none" accept="image/*">
                              </div>



                              <div class="col-12">
                                <label for="notes" class="form-label">Notes</label>
                                <textarea class="form-control" id="notes" rows="3" placeholder="Enter notes about the customer"></textarea>
                              </div>

                            </div>
                          </div>
                        </div>

                      </div>



                      {{-- MARKETING PREFERENCES --}}
                      <div class="" id="wizard-marketing" role="tabpanel" aria-labelledby="wizard-marketing-tab">

                        <div class="col-12">
                          <div class="card shadow-none border" id="marketing">
                            <div class="card-header">
                              <h4>Marketing Preferences</h4>
                            </div>
                            <div class="card-body row g-3">

                              <div class="col-md-6">
                                <label for="preferred_contact_method" class="form-label">Preferred Contact Method</label>
                                <select class="form-select" id="preferred_contact_method">
                                  <option selected disabled value="">Choose...</option>
                                  <option>Email</option>
                                  <option>Phone</option>
                                  <option>SMS</option>
                                  <option>WhatsApp</option>
                                  <option>Telegram</option>
                                </select>
                              </div>

                              <div class="col-md-6 d-flex align-items-center">
                                <div>
                                  <label class="form-label d-block">Allow Marketing Emails</label>
                                  <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="allow_marketing_emails">
                                    <label class="form-check-label" for="allow_marketing_emails">Yes</label>
                                  </div>
                                </div>
                              </div>

                              <div class="col-md-6 d-flex align-items-center">
                                <div>
                                  <label class="form-label d-block">Allow SMS Notifications</label>
                                  <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="allow_sms_notifications">
                                    <label class="form-check-label" for="allow_sms_notifications">Yes</label>
                                  </div>
                                </div>
                              </div>

                              <div class="col-md-6 d-flex align-items-center">
                                <div>
                                  <label class="form-label d-block">Allow Push Notifications</label>
                                  <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="allow_push_notifications">
                                    <label class="form-check-label" for="allow_push_notifications">Yes</label>
                                  </div>
                                </div>
                              </div>

                              <div class="col-md-6">
                                <label for="language_preference" class="form-label">Language Preference</label>
                                <select class="form-select" id="language_preference" name="language_preference" data-control="select2">
                                  <option value="">Select a Language</option>
                                  {{-- Options will be loaded dynamically --}}
                                  @foreach($languages as $language)
                                  <option
                                    value="{{ $language->id }}"
                                    data-flag="{{ asset('storage/flags/' . $language->flag_icon) }}">
                                    {{ $language->name }} ({{ $language->native_name }})
                                  </option>
                                  @endforeach
                                </select>
                                <div class="invalid-feedback">Please select a language.</div>
                              </div>

                              <div class="col-md-6">
                                <label for="timezone" class="form-label">Timezone</label>
                                <select class="form-control select2" id="timezone" name="timezone">
                                  <option value="">Select a timezone</option>
                                  @foreach(timezone_identifiers_list() as $timezone)
                                  <option value="{{ $timezone }}">{{ $timezone }}</option>
                                  @endforeach
                                </select>
                              </div>


                            </div>
                          </div>
                        </div>

                      </div>


                      <div class="" id="insurance-details-tab" role="tabpanel" aria-labelledby="insurance-details-tab">
                        <div class="col-sm-12 col-xl-12">
                          <div class="card shadow-none border" id="insurance-details">
                            <div class="card-header">
                              <h4>Insurance Policy Details</h4>
                            </div>
                            <div class="card-body row g-3">

                              <!-- Policy Type -->
                              <div class="col-xxl-6">
                                <label for="policy_type" class="form-label">Policy Type</label>
                                <select class="form-select" id="policy_type" name="policy_type">
                                  <option value="" selected disabled>Select Policy Type</option>
                                  <option value="Life">Life</option>
                                  <option value="Motor">Motor</option>
                                  <option value="Health">Health</option>
                                  <option value="Property">Property</option>
                                  <option value="Travel">Travel</option>
                                  <option value="Microinsurance">Microinsurance</option>
                                </select>
                                <div class="invalid-feedback">Please select a policy type.</div>
                              </div>

                              <!-- Coverage Type -->
                              <div class="col-xxl-6">
                                <label for="coverage_type" class="form-label">Coverage Type</label>
                                <select class="form-select" id="coverage_type" name="coverage_type">
                                  <option value="" selected disabled>Select Coverage Type</option>
                                  <option value="individual">Individual</option>
                                  <option value="family">Family</option>
                                  <option value="group">Group</option>
                                </select>
                                <div class="invalid-feedback">Please select a coverage type.</div>
                              </div>

                              <!-- Policy Name -->
                              <div class="col-xxl-6">
                                <label for="policy_name" class="form-label">Policy Name</label>
                                <input type="text" class="form-control" id="policy_name" name="policy_name" placeholder="Enter policy name">
                                <div class="invalid-feedback">Please enter the policy name.</div>
                              </div>

                              <!-- Description -->
                              <div class="col-xxl-6">
                                <label for="description" class="form-label">Description</label>
                                <textarea class="form-control" id="description" name="description" rows="2" placeholder="Policy description"></textarea>
                                <div class="invalid-feedback">Please enter a description.</div>
                              </div>

                              <!-- Start Date -->
                              <div class="col-xxl-6">
                                <label for="start_date" class="form-label">Start Date</label>
                                <input type="date" class="form-control" id="start_date" name="start_date">
                                <div class="invalid-feedback">Please select the start date.</div>
                              </div>

                              <!-- End Date -->
                              <div class="col-xxl-6">
                                <label for="end_date" class="form-label">End Date</label>
                                <input type="date" class="form-control" id="end_date" name="end_date">
                                <div class="invalid-feedback">Please select the end date.</div>
                              </div>

                              <!-- Issue Date -->
                              <div class="col-xxl-6">
                                <label for="issue_date" class="form-label">Issue Date</label>
                                <input type="date" class="form-control" id="issue_date" name="issue_date">
                                <div class="invalid-feedback">Please select the issue date.</div>
                              </div>

                              <!-- Maturity Date -->
                              <div class="col-xxl-6">
                                <label for="maturity_date" class="form-label">Maturity Date</label>
                                <input type="date" class="form-control" id="maturity_date" name="maturity_date">
                                <div class="invalid-feedback">Please select the maturity date.</div>
                              </div>

                              <!-- Renewal Date -->
                              <div class="col-xxl-6">
                                <label for="renewal_date" class="form-label">Renewal Date</label>
                                <input type="date" class="form-control" id="renewal_date" name="renewal_date">
                                <div class="invalid-feedback">Please select the renewal date.</div>
                              </div>

                              <!-- Sum Assured (in ETB) -->
                              <div class="col-xxl-6">
                                <label for="sum_assured" class="form-label">Sum Assured (ETB)</label>
                                <input type="number" step="0.01" min="0" class="form-control" id="sum_assured" name="sum_assured" placeholder="Enter sum assured">
                                <div class="invalid-feedback">Please enter the sum assured amount.</div>
                              </div>

                              <!-- Premium Amount (in ETB) -->
                              <div class="col-xxl-6">
                                <label for="premium_amount" class="form-label">Premium Amount (ETB)</label>
                                <input type="number" step="0.01" min="0" class="form-control" id="premium_amount" name="premium_amount" placeholder="Enter premium amount">
                                <div class="invalid-feedback">Please enter the premium amount.</div>
                              </div>

                              <!-- Premium Frequency -->
                              <div class="col-xxl-6">
                                <label for="premium_frequency" class="form-label">Premium Frequency</label>
                                <select class="form-select" id="premium_frequency" name="premium_frequency">
                                  <option value="" selected disabled>Select Premium Frequency</option>
                                  <option value="monthly">Monthly</option>
                                  <option value="quarterly">Quarterly</option>
                                  <option value="semi-annually">Semi-Annually</option>
                                  <option value="annually">Annually</option>
                                </select>
                                <div class="invalid-feedback">Please select premium frequency.</div>
                              </div>

                              <!-- Payment Method -->
                              <div class="col-xxl-6">
                                <label for="payment_method" class="form-label">Payment Method</label>
                                <select class="form-select" id="payment_method" name="payment_method">
                                  <option value="" selected disabled>Select Payment Method</option>
                                  <option value="bank_transfer">Bank Transfer</option>
                                  <option value="mobile_money">Mobile Money</option>
                                  <option value="cash">Cash</option>
                                  <option value="credit_card">Credit Card</option>
                                </select>
                                <div class="invalid-feedback">Please select payment method.</div>
                              </div>

                              <!-- Auto Renew -->
                              <div class="col-xxl-6 d-flex align-items-center">
                                <div class="form-check mt-4">
                                  <input class="form-check-input" type="checkbox" id="auto_renew" name="auto_renew" value="1">
                                  <label class="form-check-label" for="auto_renew">Auto Renew</label>
                                </div>
                              </div>

                              <!-- Status -->
                              <div class="col-xxl-6">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-select" id="status" name="status">
                                  <option value="" selected disabled>Select Status</option>
                                  <option value="active">Active</option>
                                  <option value="inactive">Inactive</option>
                                  <option value="cancelled">Cancelled</option>
                                  <option value="expired">Expired</option>
                                  <option value="pending">Pending</option>
                                </select>
                                <div class="invalid-feedback">Please select policy status.</div>
                              </div>

                              <!-- Cancellation Reason -->
                              <div class="col-xxl-6">
                                <label for="cancellation_reason" class="form-label">Cancellation Reason</label>
                                <textarea class="form-control" id="cancellation_reason" name="cancellation_reason" rows="2" placeholder="Reason for cancellation (if any)"></textarea>
                              </div>

                              <!-- Number of Beneficiaries -->
                              <div class="col-xxl-6">
                                <label for="number_of_beneficiaries" class="form-label">Number of Beneficiaries</label>
                                <input type="number" min="0" max="10" class="form-control" id="number_of_beneficiaries" name="number_of_beneficiaries" placeholder="Enter number of beneficiaries">
                                <div class="invalid-feedback">Please enter number of beneficiaries (0 or more).</div>
                              </div>

                              <!-- Attachments (URLs) -->
                              <div class="col-xxl-12">
                                <label for="attachments" class="form-label">Attachments (JSON URLs)</label>
                                <textarea class="form-control" id="attachments" name="attachments" rows="3" placeholder='Enter JSON array of attachment URLs'></textarea>
                                <div class="form-text">Example: ["https://example.com/doc1.jpg", "https://example.com/doc2.pdf"]</div>
                              </div>

                              <!-- Notes -->
                              <div class="col-xxl-12">
                                <label for="notes" class="form-label">Notes</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3" placeholder="Additional notes or conditions"></textarea>
                              </div>

                              <!-- Source -->
                              <div class="col-xxl-6">
                                <label for="source" class="form-label">Source</label>
                                <select class="form-select" id="policy_source" name="policy_source">
                                  <option value="" selected disabled>Select Source</option>
                                  <option value="agent">Agent</option>
                                  <option value="branch">Branch</option>
                                  <option value="online">Online</option>
                                  <option value="referral">Referral</option>
                                </select>
                                <div class="invalid-feedback">Please select source.</div>
                              </div>

                              <!-- Created By -->


                            </div>
                          </div>
                        </div>
                      </div>


                      <div class="" id="beneficiaries-tab" role="tabpanel" aria-labelledby="beneficiaries-tab">
                        <div class="col-sm-12 col-xl-12">
                          <div class="card shadow-none border" id="beneficiaries">
                            <div class="card-header">
                              <h4>Beneficiary Information</h4>
                            </div>
                            <div class="card-body">

                              <div id="beneficiaries-list" class="mb-3"></div>

                              <button type="button" class="btn btn-primary mb-3" id="add-beneficiary-btn">Add Beneficiary</button>
                              <div class="text-muted">* Total allocation must equal 100%</div>

                            </div>
                          </div>
                        </div>

                        <script>
                          document.getElementById('add-beneficiary-btn').addEventListener('click', function() {
                            const container = document.getElementById('beneficiaries-list');
                            const index = container.children.length;

                            const row = document.createElement('div');
                            row.className = 'row g-3 align-items-end mb-2 beneficiary-row';

                            row.innerHTML = `
                            <div class="col-xxl-5 col-sm-6">
                              <label for="beneficiary_name_${index}" class="form-label">Name</label>
                              <input type="text" class="form-control" id="beneficiary_name_${index}" >
                              <div class="invalid-feedback">.</div>
                            </div>
                            <div class="col-xxl-4 col-sm-4">
                              <label for="beneficiary_relation_${index}" class="form-label">Relation</label>
                              <input type="text" class="form-control" id="beneficiary_relation_${index}" >
                              <div class="invalid-feedback">.</div>
                            </div>
                            <div class="col-xxl-2 col-sm-2">
                              <label for="beneficiary_allocation_${index}" class="form-label">%</label>
                              <input type="number" class="form-control" id="beneficiary_allocation_${index}" min="0" max="100" >
                              <div class="invalid-feedback">0–100% .</div>
                            </div>
                            <div class="col-xxl-1">
                              <button type="button" class="btn btn-danger btn-sm remove-beneficiary-btn">&times;</button>
                            </div>
                          `;

                            container.appendChild(row);

                            row.querySelector('.remove-beneficiary-btn').addEventListener('click', function() {
                              row.remove();
                            });
                          });
                        </script>
                      </div>


                      <div class="" id="risk-assessment-tab" role="tabpanel" aria-labelledby="risk-assessment-tab">
                        <div class="col-sm-12 col-xl-12">
                          <div class="card shadow-none border" id="risk-assessment">
                            <div class="card-header">
                              <h4>Risk Assessment</h4>
                            </div>
                            <div class="card-body">

                              <div class="col-xxl-6">
                                <label for="risk_flags" class="form-label">Risk Flags</label>
                                <select multiple class="form-select" id="risk_flags">
                                  <option value="smoker">Smoker</option>
                                  <option value="chronic_illness">Chronic Illness</option>
                                  <option value="high_bmi">High BMI</option>
                                  <option value="hazardous_occupation">Hazardous Occupation</option>
                                  <option value="high_risk_travel">High Risk Travel</option>
                                </select>
                                <div class="form-text">Select all that apply</div>
                              </div>

                              <div class="col-xxl-6">
                                <label for="risk_score" class="form-label">Risk Score</label>
                                <input type="number" class="form-control" id="risk_score" min="0" max="100" placeholder="0–100">
                              </div>

                              <div class="col-12">
                                <label for="risk_notes" class="form-label">Assessment Notes</label>
                                <textarea class="form-control" id="risk_notes" rows="3" placeholder="Notes or comments..."></textarea>
                              </div>

                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- Container-fluid Ends-->
@endsection

@section('scripts')
<!-- calendar js-->
<script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
<script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
<script src="{{ asset('assets/js/editors/quill.js') }}"></script>
<script src="{{ asset('assets/js/custom-add-product4.js') }}"></script>
<script src="{{ asset('assets/js/bookmark/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/custom-validation/validation.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.9.3/min/dropzone.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/jquery.validate.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/additional-methods.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


<script>
  $(document).ready(function() {
    // Initialize Select2 for multiselects & selects
    $('#risk_flags').select2({
      placeholder: 'Select Risk Flags'
    });
    $('#preferred_contact_method').select2({
      placeholder: 'Select Contact Method',
      allowClear: true
    });
    $('#language_preference').select2({
      placeholder: 'Select Language',
      allowClear: true
    });
    $('#timezone').select2({
      placeholder: 'Select Timezone',
      allowClear: true
    });
    $('#policy_type').select2({
      placeholder: 'Select Policy Type',
      allowClear: true
    });
    $('#country').select2({
      placeholder: 'Select Country',
      allowClear: true
    });
    $('#region').select2({
      placeholder: 'Select Administrative Region',
      allowClear: true
    });
    $('#city').select2({
      placeholder: 'Select Sub city/Zone',
      allowClear: true
    });
    $('#wereda').select2({
      placeholder: 'Select Wereda/Town',
      allowClear: true
    });
    $('#place_of_birth').select2({
      placeholder: 'Select Place of Birth',
      allowClear: true
    });
    $('#gender').select2({
      placeholder: 'Select Gender',
      allowClear: true
    });
    $('#marital_status').select2({
      placeholder: 'Select Marital Status',
      allowClear: true
    });

    // Validation rules
    $("#customerForm").validate({
      ignore: [], // Validate hidden select2 fields
      rules: {
        first_name: {
          required: true,
          maxlength: 100
        },
        middle_name: {
          maxlength: 100
        },
        last_name: {
          required: true,
          maxlength: 100
        },
        gender: {
          required: true
        },
        date_of_birth: {
          required: true,
          date: true
        },
        place_of_birth: {
          required: true
        },
        marital_status: {
          required: true
        },
        nationality: {
          required: true,
          maxlength: 100
        },
        national_id: {
          maxlength: 50
        },
        passport_number: {
          maxlength: 50
        },
        tax_id: {
          maxlength: 50
        },
        email: {
          required: true,
          email: true,
          maxlength: 100
        },
        phone: {
          required: true,
          phoneUS: false,
          maxlength: 20
        }, // customize phone regex if needed
        alt_phone: {
          maxlength: 20
        },
        country: {
          required: true
        },
        region: {
          required: true
        },
        city: {
          required: true
        },
        wereda: {
          required: true
        },
        kebele: {
          maxlength: 255
        },
        house_no: {
          maxlength: 255
        },
        address: {
          required: true
        },
        postal_code: {
          maxlength: 20
        },
        occupation: {
          maxlength: 100
        },
        policy_type: {
          required: true
        },
        coverage_amount: {
          required: true,
          number: true,
          min: 0
        },
        premium_amount: {
          required: true,
          number: true,
          min: 0
        },
        policy_start_date: {
          required: true,
          date: true
        },
        policy_end_date: {
          required: true,
          date: true
        },
        policy_notes: {
          maxlength: 1000
        },
        risk_score: {
          number: true,
          min: 0,
          max: 100
        },
        risk_notes: {
          maxlength: 1000
        },
        customer_status: {
          required: true
        },
        source: {
          required: true
        },
        coverage_type: {
          required: true
        },
        policy_name: {
          required: true
        },
        start_date: {
          required: true
        },
        issue_date: {
          required: true
        },
        end_date: {
          required: true
        },
        sum_assured: {
          required: true
        },
        premium_frequency: {
          required: true
        },
        payment_method: {
          required: true
        },
        status: {
          required: true
        },
        source: {
          required: true
        },
        policy_source: {
          required: true
        },

      },
      messages: {
        first_name: "Please enter first name",
        last_name: "Please enter last name",
        gender: "Please select gender",
        date_of_birth: "Please enter valid date of birth",
        place_of_birth: "Please select place of birth",
        marital_status: "Please select marital status",
        nationality: "Please enter nationality",
        email: "Please enter a valid email",
        phone: "Please enter phone number",
        country: "Please select country",
        region: "Please select administrative region",
        city: "Please select sub city/zone",
        wereda: "Please select wereda/town",
        address: "Please enter address",
        policy_type: "Please select policy type",
        coverage_amount: "Please enter coverage amount",
        premium_amount: "Please enter premium amount",
        policy_start_date: "Please enter start date",
        policy_end_date: "Please enter end date",
        policy_end_date: "Please enter end date",
        customer_status: "Please select customer status",
        source: "Please select source",
        coverage_type: "Please select coverage type",
        policy_name: "Please enter policy name",
        start_date: "Please enter start date",
        issue_date: "Please enter issue date",
        end_date: "Please enter end date",
        sum_assured: "Please enter sum assured:",
        premium_frequency: "Please select premium frequency",
        payment_method: "Please select payment method",
        status: "Please select status",
        source: "Please select source",
        policy_source: "Please select policy source",
      },
      errorPlacement: function(error, element) {
        if (element.hasClass('select2-hidden-accessible')) {
          error.insertAfter(element.next('span.select2'));
        } else {
          error.insertAfter(element);
        }
      },
      submitHandler: function(form) {
        // Collect all form data here
        let formData = {
          first_name: $("#first_name").val(),
          middle_name: $("#middle_name").val(),
          last_name: $("#last_name").val(),
          gender: $("#gender").val(),
          date_of_birth: $("#date_of_birth").val(),
          place_of_birth: $("#place_of_birth").val(),
          marital_status: $("#marital_status").val(),
          nationality: $("#nationality").val(),
          national_id: $("#national_id").val(),
          passport_number: $("#passport_number").val(),
          tax_id: $("#tax_id").val(),
          email: $("#email").val(),
          phone: $("#phone").val(),
          alt_phone: $("#alt_phone").val(),
          country: $("#country").val(),
          region: $("#region").val(),
          city: $("#city").val(),
          wereda: $("#wereda").val(),
          kebele: $("#kebele").val(),
          house_no: $("#house_no").val(),
          address: $("#address").val(),
          postal_code: $("#postal_code").val(),
          occupation: $("#occupation").val(),
          policy_type: $("#policy_type").val(),
          coverage_amount: $("#coverage_amount").val(),
          premium_amount: $("#premium_amount").val(),
          policy_start_date: $("#policy_start_date").val(),
          policy_end_date: $("#policy_end_date").val(),
          policy_notes: $("#policy_notes").val(),
          risk_flags: $("#risk_flags").val(), // array of selected values
          risk_score: $("#risk_score").val(),
          customer_status: $("#customer_status").val(),
          source: $("#source").val(),
          coverage_type: $("#coverage_type").val(),
          policy_name: $("#policy_name").val(),
          start_date: $("#start_date").val(),
          issue_date: $("#issue_date").val(),
          end_date: $("#end_date").val(),
          sum_assured: $("#sum_assured").val(),
          premium_frequency: $("#premium_frequency").val(),
          payment_method: $("#payment_method").val(),
          status: $("#status").val(),
          source: $("#source").val(),
          policy_source: $("#policy_source").val(),


        };

        // Add dynamic beneficiaries array
        formData.beneficiaries = [];
        $(".beneficiary-row").each(function() {
          let idx = $(this).index();
          let name = $(this).find(`input[id^="beneficiary_name_"]`).val();
          let relation = $(this).find(`input[id^="beneficiary_relation_"]`).val();
          let allocation = $(this).find(`input[id^="beneficiary_allocation_"]`).val();
          formData.beneficiaries.push({
            name: name,
            relation: relation,
            allocation: allocation
          });
        });

        // Disable submit button + show spinner
        let $btn = $("#submitBtn");
        $btn.prop("disabled", true);
        $btn.html(`<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Saving...`);

        // AJAX POST submission
        const route = "{{ route('admin.customers.store') }}";

        $.ajax({
          url: route,
          method: 'POST',
          data: JSON.stringify(formData),
          contentType: "application/json",
          headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          },
          beforeSend: function() {
            toastr.options = {
              "positionClass": "toast-bottom-right",
              "timeOut": 0,
              "extendedTimeOut": 0,
              "closeButton": true,
              "progressBar": true
            };
            toastr.info('Submitting customer data...', 'Processing');
            $btn.prop("disabled", true);
            $btn.html(`<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Saving...`);
          },
          success: function(response) {
            toastr.clear(); // Remove "processing" toast

            toastr.options = {
              "positionClass": "toast-bottom-right",
              "timeOut": 5000,
              "extendedTimeOut": 1000,
              "closeButton": true,
              "progressBar": true
            };

            toastr.success('<i class="fas fa-check-circle me-1 text-success"></i> Customer saved successfully!', 'Success');


            $btn.prop("disabled", false);
            $btn.html("Submit");
            $("#customerForm")[0].reset();
            $('.select2').val(null).trigger('change');
            $("#beneficiaries-list").empty();
          },

          error: function(xhr) {
            toastr.clear(); // Remove "processing" toast

            let errMsg = "An error occurred.";
            if (xhr.responseJSON && xhr.responseJSON.errors) {
              errMsg = Object.values(xhr.responseJSON.errors).map(msgArr => msgArr.join(', ')).join('<br>');
            } else if (xhr.responseText) {
              errMsg = xhr.responseText;
            }

            toastr.options = {
              "positionClass": "toast-bottom-right",
              "timeOut": 7000,
              "extendedTimeOut": 1500,
              "closeButton": true,
              "progressBar": true
            };
            toastr.error(errMsg, 'Error');

            $btn.prop("disabled", false);
            $btn.html("Submit");
          }
        });


        return false; // prevent default form submission
      }
    });
  });
</script>



<script>
  document.addEventListener('DOMContentLoaded', function() {
    const navLinks = document.querySelectorAll('.nav-link[data-bs-toggle="pill"]');

    navLinks.forEach(link => {
      link.addEventListener('shown.bs.tab', function(event) {
        const scrollTargetSelector = event.target.getAttribute('data-scroll-target');
        const card = document.querySelector(scrollTargetSelector);
        const header = card?.querySelector('.card-header');

        if (card && header) {
          setTimeout(() => {
            // Get offsetTop of the header and apply an offset if you have a sticky navbar
            const offset = 80; // adjust this value based on your navbar height
            const headerTop = header.getBoundingClientRect().top + window.pageYOffset - offset;

            window.scrollTo({
              top: headerTop,
              behavior: 'smooth'
            });

            // Add glass-like highlight
            card.classList.add('bg-light-tertiary');
            setTimeout(() => {
              card.classList.remove('bg-light-tertiary');
            }, 1500);
          }, 150);
        }
      });
    });
  });





  // JS to dynamically add beneficiary input rows
  document.getElementById('add-beneficiary-btn').addEventListener('click', function() {
    const container = document.getElementById('beneficiaries-list');

    const index = container.children.length;
    const beneficiaryRow = document.createElement('div');
    beneficiaryRow.className = 'row g-3 align-items-end mb-2 beneficiary-row';

    beneficiaryRow.innerHTML = `
      <div class="col-xxl-5 col-sm-6">
        <label class="form-label" for="beneficiary_name_${index}">Beneficiary Name</label>
        <input type="text" class="form-control" id="beneficiary_name_${index}" placeholder="Full name" required>
        <div class="invalid-feedback">Please enter beneficiary name.</div>
      </div>
      <div class="col-xxl-4 col-sm-4">
        <label class="form-label" for="beneficiary_relation_${index}">Relation</label>
        <input type="text" class="form-control" id="beneficiary_relation_${index}" placeholder="Relation to customer" required>
        <div class="invalid-feedback">Please specify relation.</div>
      </div>
      <div class="col-xxl-2 col-sm-2">
        <label class="form-label" for="beneficiary_allocation_${index}">Allocation %</label>
        <input type="number" class="form-control" id="beneficiary_allocation_${index}" placeholder="%" min="0" max="100" required>
        <div class="invalid-feedback">Enter allocation (0-100).</div>
      </div>
      <div class="col-xxl-1 col-sm-12">
        <button type="button" class="btn btn-danger btn-sm remove-beneficiary-btn" title="Remove Beneficiary">&times;</button>
      </div>
    `;

    container.appendChild(beneficiaryRow);

    // Attach remove handler
    beneficiaryRow.querySelector('.remove-beneficiary-btn').addEventListener('click', function() {
      beneficiaryRow.remove();
    });
  });



  // Example Bootstrap validation script for all forms on the page
  (function() {
    'use strict'

    var forms = document.querySelectorAll('.needs-validation')

    Array.prototype.slice.call(forms)
      .forEach(function(form) {
        form.addEventListener('submit', function(event) {
          if (!form.checkValidity()) {
            event.preventDefault()
            event.stopPropagation()
          }
          form.classList.add('was-validated')
        }, false)
      })
  })()

  document.addEventListener('DOMContentLoaded', function() {
    function formatCountry(country) {
      if (!country.id) {
        return country.text;
      }

      var flagUrl = $(country.element).data('flag');
      if (!flagUrl) {
        return country.text;
      }

      var $country = $(
        `<span><img src="${flagUrl}" style="width:20px; height:14px; margin-right:8px; vertical-align:middle;" /> ${country.text}</span>`
      );
      return $country;
    }

    $('.select2-country').select2({
      templateResult: formatCountry,
      templateSelection: formatCountry,
      placeholder: "Select country",
      allowClear: true,
      width: '100%'
    });
  });

  document.addEventListener('DOMContentLoaded', function() {
    Inputmask({
      mask: "+251 999 999 999",
      placeholder: "_",
      showMaskOnHover: false,
      showMaskOnFocus: true
    }).mask('.ethiopian-phone');
  });


  function formatCountry(country) {
    if (!country.id) {
      return country.text;
    }

    const flagUrl = $(country.element).data('flag');
    if (flagUrl) {
      return $('<span><img src="' + flagUrl + '" class="me-2" width="20"/> ' + country.text + '</span>');
    }
    return country.text;
  }

  $(document).ready(function() {
    $('.select2-country').select2({
      templateResult: formatCountry,
      templateSelection: formatCountry,
      theme: 'bootstrap-5',
      placeholder: 'Select Country',
      allowClear: true
    });
  });


  $(document).ready(function() {
    // Initialize Select2 with country flags
    function formatCountry(country) {
      if (!country.id) return country.text;
      let flagUrl = $(country.element).data('flag'); // get flag from option
      return $('<span><img src="' + flagUrl + '" class="me-2" style="width: 20px; height: 14px;" />' + country.text + '</span>');
    }

    $('#country').select2({
      placeholder: 'Select Country',
      allowClear: true,
      width: '100%',
      templateResult: formatCountry,
      templateSelection: formatCountry,
      escapeMarkup: m => m
    });

    $('#region, #city, #wereda').select2({
      placeholder: 'Select an option',
      allowClear: true,
      width: '100%'
    });

    // Clear all selects
    $('#country, #region, #city, #wereda').val(null).trigger('change').prop('disabled', false);

    function resetSelect($select, placeholder) {
      $select.prop('disabled', true).empty().append(`<option value="">${placeholder}</option>`);
      $select.val(null).trigger('change');
    }

    function showError(id, message) {
      $(`#${id}-error-message`).text(message);
      $(`#${id}-error`).removeClass('d-none');
      setTimeout(() => $(`#${id}-error`).addClass('d-none'), 4000); // Hide after 4 seconds
    }

    // COUNTRY → REGION
    $('#country').on('change', function() {
      let countryId = $(this).val();
      resetSelect($('#region'), 'Select Region');
      resetSelect($('#city'), 'Select City');
      resetSelect($('#wereda'), 'Select Wereda');

      if (!countryId) return;

      $('#region-spinner').removeClass('d-none');
      $('#region-error').addClass('d-none');

      $.ajax({
        url: `/admin/get-regions/${countryId}`,
        type: 'GET',
        success: function(regions) {
          $('#region-spinner').addClass('d-none');
          let $region = $('#region');
          $region.prop('disabled', false).empty().append('<option value="">Select administrative region or city</option>');
          if (regions.length > 0) {
            regions.forEach(region => {
              $region.append(`<option value="${region.id}">${region.name}</option>`);
            });
          } else {
            showError('region', 'No administrative region or city found for selected country.');
          }
        },
        error: function() {
          $('#region-spinner').addClass('d-none');
          showError('region', 'Failed to load administrative region or city.');
        }
      });
    });

    // REGION → CITY
    $('#region').on('change', function() {
      let regionId = $(this).val();
      resetSelect($('#city'), 'Select City');
      resetSelect($('#wereda'), 'Select Wereda');

      if (!regionId) return;

      $('#city-spinner').removeClass('d-none');
      $('#city-error').addClass('d-none');

      $.ajax({
        url: `/admin/get-cities/${regionId}`,
        type: 'GET',
        success: function(cities) {
          $('#city-spinner').addClass('d-none');
          let $city = $('#city');
          $city.prop('disabled', false).empty().append('<option value="">Select city or zone</option>');
          if (cities.length > 0) {
            cities.forEach(city => {
              $city.append(`<option value="${city.id}">${city.name}</option>`);
            });
          } else {
            showError('city', 'No sub city or zone found for selected administrative region or city.');
          }
        },
        error: function() {
          $('#city-spinner').addClass('d-none');
          showError('city', 'Failed to load sub city or zone.');
        }
      });
    });

    // CITY → WEREDA
    $('#city').on('change', function() {
      let cityId = $(this).val();
      resetSelect($('#wereda'), 'Select Wereda');

      if (!cityId) return;

      $('#wereda-spinner').removeClass('d-none');
      $('#wereda-error').addClass('d-none');

      $.ajax({
        url: `/admin/get-woredas/${cityId}`,
        type: 'GET',
        success: function(woredas) {
          $('#wereda-spinner').addClass('d-none');
          let $wereda = $('#wereda');
          $wereda.prop('disabled', false).empty().append('<option value="">Select wereda or town</option>');
          if (woredas.length > 0) {
            woredas.forEach(w => {
              $wereda.append(`<option value="${w.id}">${w.name}</option>`);
            });
          } else {
            showError('wereda', 'No woredas or towns found for selected city.');
          }
        },
        error: function() {
          $('#wereda-spinner').addClass('d-none');
          showError('wereda', 'Failed to load woredas or towns.');
        }
      });
    });

    // REGION must have COUNTRY
    $('#region').on('select2:opening', function(e) {
      const $country = $('#country');
      const countrySelected = $country.val();
      const countryOptions = $country.find('option').length;

      if (!countrySelected || countryOptions <= 1) {
        e.preventDefault();
        showError('region', 'Please select a valid country first.');
      }
    });

    // CITY must have REGION
    $('#city').on('select2:opening', function(e) {
      const $region = $('#region');
      const regionSelected = $region.val();
      const regionEnabled = !$region.prop('disabled');
      const regionOptions = $region.find('option').length;

      if (!regionSelected || !regionEnabled || regionOptions <= 1) {
        e.preventDefault();
        showError('city', 'Please select a valid region first.');
      }
    });

    // WEREDA must have CITY
    $('#wereda').on('select2:opening', function(e) {
      const $city = $('#city');
      const citySelected = $city.val();
      const cityEnabled = !$city.prop('disabled');
      const cityOptions = $city.find('option').length;

      if (!citySelected || !cityEnabled || cityOptions <= 1) {
        e.preventDefault();
        showError('wereda', 'Please select a valid city first.');
      }
    });



  });

  $(document).ready(function() {
    function formatLanguage(lang) {
      if (!lang.id) return lang.text;
      let flag = $(lang.element).data('flag');
      return $(`<span><img src="${flag}" class="me-2" style="width:20px; height:14px;" /> ${lang.text}</span>`);
    }

    $('#language_preference').select2({
      placeholder: 'Select a Language',
      allowClear: true,
      width: '100%',
      templateResult: formatLanguage,
      templateSelection: formatLanguage,
      escapeMarkup: m => m
    });
  });

  $(document).ready(function() {
    $('#timezone').select2({
      placeholder: 'Select a timezone',
      allowClear: true
    });
  });

  $(document).ready(function() {
    function formatCountry(country) {
      if (!country.id) {
        return country.text;
      }
      const flagUrl = $(country.element).data('flag');
      if (!flagUrl) {
        return country.text;
      }

      return $(
        `<span><img src="${flagUrl}" class="me-2" style="width: 20px; height: 14px; object-fit: cover;" />${country.text}</span>`
      );
    }

    $('.select2-country').select2({
      placeholder: "Select Place of Birth",
      allowClear: true,
      templateResult: formatCountry,
      templateSelection: formatCountry,
      escapeMarkup: function(m) {
        return m;
      }
    });


  });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    const dropzone = document.getElementById('profilePictureDropzone');
    const fileInput = document.getElementById('profile_picture');
    const placeholder = document.getElementById('profilePicturePlaceholder');
    const previewWrapper = dropzone.querySelector('.dz-preview');
    const previewImage = document.getElementById('profilePicturePreview');
    const removeBtn = dropzone.querySelector('.dz-remove');

    // Click on dropzone opens file input
    dropzone.addEventListener('click', () => fileInput.click());

    // Handle file selection
    fileInput.addEventListener('change', function() {
      const file = this.files[0];
      if (file && file.type.startsWith('image/')) {
        const reader = new FileReader();
        reader.onload = function(e) {
          previewImage.src = e.target.result;
          previewWrapper.classList.remove('d-none');
          placeholder.classList.add('d-none');
        };
        reader.readAsDataURL(file);
      }
    });

    // Handle file removal
    removeBtn.addEventListener('click', function(e) {
      e.stopPropagation(); // Prevent triggering file input
      fileInput.value = "";
      previewWrapper.classList.add('d-none');
      previewImage.src = "#";
      placeholder.classList.remove('d-none');
    });

    // Optional: Drag-and-drop support
    dropzone.addEventListener('dragover', e => e.preventDefault());
    dropzone.addEventListener('drop', e => {
      e.preventDefault();
      const file = e.dataTransfer.files[0];
      if (file && file.type.startsWith('image/')) {
        fileInput.files = e.dataTransfer.files;
        const reader = new FileReader();
        reader.onload = function(e) {
          previewImage.src = e.target.result;
          previewWrapper.classList.remove('d-none');
          placeholder.classList.add('d-none');
        };
        reader.readAsDataURL(file);
      }
    });
  });
</script>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    const navLinks = document.querySelectorAll('.nav-link[data-bs-toggle="pill"]');
    const cardSections = document.querySelectorAll('.card[id]');

    let currentCard = null;
    let currentNav = null;

    function clearPreviousHighlights() {
      if (currentCard) currentCard.classList.remove('bg-light-tertiary');
      if (currentNav) currentNav.classList.remove('active');
    }

    function setActive(card, nav) {
      clearPreviousHighlights();

      // Set new
      if (card) {
        card.classList.add('bg-light-tertiary');
        currentCard = card;
      }
      if (nav) {
        nav.classList.add('active');
        currentNav = nav;
      }
    }

    // Tab shown via nav
    navLinks.forEach(link => {
      link.addEventListener('shown.bs.tab', function(event) {
        const targetSelector = event.target.getAttribute('data-scroll-target');
        const card = document.querySelector(targetSelector);
        setActive(card, event.target);
      });
    });

    // Hover or click card to activate tab
    cardSections.forEach(card => {
      const cardId = card.id;
      const relatedNav = document.querySelector(`.nav-link[data-scroll-target="#${cardId}"]`);
      if (!relatedNav) return;

      ['click', 'mouseenter'].forEach(eventType => {
        card.addEventListener(eventType, function() {
          const bsTab = new bootstrap.Tab(relatedNav);
          bsTab.show(); // Will trigger shown.bs.tab and apply highlight via setActive
        });
      });
    });
  });
</script>


@endsection