@extends('layouts.master')

@section('title', 'Tour')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/tour.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">Tour</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Bonus Ui</li>
                <li class="breadcrumb-item f-w-400 active">Tour</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="user-profile">
            <div class="row">
                <!-- Container-fluid starts-->
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="user-profile">
            <div class="row">
                <!-- user profile first-style start-->
                <div class="col-sm-12">
                    <div class="card hovercard text-center">
                        <div class="cardheader"></div>
                        <div class="user-image">
                            <div class="avatar"><img alt="" src="{{ asset('assets/images/user/7.jpg') }}"
                                    data-intro="This is mofi profile"></div>
                            <div class="icon-wrapper"><i class="icofont icofont-pencil-alt-5"
                                    data-intro="Change mofi profile image here"></i></div>
                        </div>
                        <div class="info">
                            <div class="row g-3" data-intro="This is your profile details">
                                <div class="col-sm-6 col-xl-4 order-sm-1 order-xl-0">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <div class="text-start tour-email">
                                                <h6 class="tour-mb-space"><i class="fa fa-envelope"></i>   Email</h6><span
                                                    class="text-truncate">William@jourrapide.com</span>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="text-start ttl-sm-mb-0 tour-email">
                                                <h6 class="tour-mb-space"><i class="fa fa-calendar"></i>   BOD</h6><span>02
                                                    January 1988</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-xl-4 order-sm-0 order-xl-1">
                                    <div class="user-designation tour-email">
                                        <div class="title"><a target="_blank" href="">William C. Jennings</a></div>
                                        <div class="desc mt-2"> Web Designer</div>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-xl-4 order-sm-2 order-xl-2">
                                    <div class="row g-3">
                                        <div class="col-md-6 mt-0 mt-sm-3">
                                            <div class="text-start ttl-xs-mt tour-email">
                                                <h6 class="tour-mb-space"><i class="fa fa-phone"></i>   Contact Us</h6>
                                                <span>US 310-273-0666</span>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="text-start ttl-sm-mb-0 tour-email">
                                                <h6 class="tour-mb-space"><i class="fa fa-location-arrow"></i>   Location
                                                </h6><span>4377 Libby Street Beverly Hills</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="social-media" data-intro="This is your social details">
                                <ul class="list-inline">
                                    <li class="list-inline-item"><a href="https://www.facebook.com/" target="_blank"><i
                                                class="fa fa-facebook"></i></a></li>
                                    <li class="list-inline-item"><a href="https://accounts.google.com/" target="_blank"><i
                                                class="fa fa-google-plus"></i></a></li>
                                    <li class="list-inline-item"><a href="https://twitter.com/" target="_blank"><i
                                                class="fa fa-twitter"></i></a></li>
                                    <li class="list-inline-item"><a href="https://www.instagram.com/" target="_blank"><i
                                                class="fa fa-instagram"></i></a></li>
                                    <li class="list-inline-item"><a href="https://rss.app/" target="_blank"><i
                                                class="fa fa-rss"></i></a></li>
                                </ul>
                            </div>
                            <div class="follow">
                                <div class="row">
                                    <div class="col-6 border-right">
                                        <div class="follow-num counter">25.8K</div><span>Follower</span>
                                    </div>
                                    <div class="col-6">
                                        <div class="follow-num counter">65.2M</div><span>Following</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- user profile first-style end-->
                <!-- user profile third-style start-->
                <div class="col-sm-12">
                    <div class="card">
                        <div class="profile-img-style">
                            <div class="row g-2">
                                <div class="col-sm-8">
                                    <div class="d-flex"><img class="img-thumbnail rounded-circle me-3"
                                            src="{{ asset('assets/images/user/7.jpg') }}" alt="Generic placeholder image">
                                        <div class="flex-grow-1 align-self-center">
                                            <h5 class="mt-0 user-name">William C. Jennings</h5>
                                            <div class="tour-wrapper"><span>25 Jan</span><i
                                                    class="tour-dot fa fa-circle"></i><span class="txt-danger">1 min
                                                    read</span></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 align-self-center mt-0 text-end">
                                    <div class="social-media social-tour" data-intro="This is your social details">
                                        <ul class="list-inline">
                                            <li class="list-inline-item"><a href="https://www.facebook.com/"
                                                    target="_blank"><i class="fa fa-facebook"></i></a></li>
                                            <li class="list-inline-item"><a href="https://accounts.google.com/"
                                                    target="_blank"><i class="fa fa-google-plus"></i></a></li>
                                            <li class="list-inline-item"><a href="https://twitter.com/"
                                                    target="_blank"><i class="fa fa-twitter"></i></a></li>
                                            <li class="list-inline-item"><a href="https://www.instagram.com/"
                                                    target="_blank"><i class="fa fa-instagram"></i></a></li>
                                            <li class="list-inline-item"><a href="https://rss.app/" target="_blank"><i
                                                        class="fa fa-rss"></i></a></li>
                                        </ul>
                                        <div class="float-sm-end"><small>10 Hours ago</small></div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <p class="block-ellipsis">A person who interacts with a given system, platform, or gadget in
                                order to carry out a particular activity or obtain specific data is referred to as a user. A
                                user is someone who interacts with software, websites, or electronic gadgets in the context
                                of technology.</p>
                            <div class="row g-3 mt-2 pictures" id="aniimated-thumbnials-2"><a class="col-sm-6"
                                    href="javascript:void(0)">
                                    <div class="tour-blog"><img class="img-fluid rounded"
                                            src="{{ asset('assets/images/other-images/mountain.jpg') }}" alt="mountain">
                                    </div>
                                </a><a class="col-sm-6" href="javascript:void(0)">
                                    <div class="tour-blog"><img class="img-fluid rounded"
                                            src="{{ asset('assets/images/other-images/sea.jpg') }}" alt="sea"></div>
                                </a></div>
                            <div class="like-comment mt-4" data-intro="This is your like-comment-share icons">
                                <ul class="list-inline">
                                    <li class="list-inline-item b-r-gray pe-3">
                                        <label class="m-0"><a href="#"><i
                                                    class="fa fa-heart"></i></a>  Like</label>
                                    </li>
                                    <li class="list-inline-item b-r-gray pe-3">
                                        <label class="m-0"><a href="#"><i
                                                    class="fa fa-comment"></i></a>  Comment</label>
                                    </li>
                                    <li class="list-inline-item">
                                        <label class="m-0"><a href="#"><i
                                                    class="fa fa-paper-plane"></i></a>  Share</label>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- user profile third-style end-->
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <!-- calendar js-->
    <script src="{{ asset('assets/js/tour/intro.js') }}"></script>
    <script src="{{ asset('assets/js/tour/intro-init.js') }}"></script>
@endsection
