@extends('layouts.master')

@section('title', 'E-commerce Dashboard')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/date-picker.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/owlcarousel.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/rating.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/vector-map.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700"> Ecommerce Dashboard</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Dashboard</li>
                <li class="breadcrumb-item f-w-400 active">Ecommerce</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid dashboard-3">
        <div class="row">
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Total Sells</h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a></div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/icon/coin1.png') }}"
                                    alt="icon"></div>
                            <div class="flex-grow-1">
                                <div class="d-flex align-items-center gap-2">
                                    <h2>12,463</h2>
                                    <div class="d-flex total-icon">
                                        <p class="mb-0 up-arrow bg-light-success"><i
                                                class="fa fa-arrow-up text-success"></i></p><span
                                            class="f-w-500 font-success">+ 20.08% </span>
                                    </div>
                                </div>
                                <p class="text-truncate">Compared to Jan 2024</p>
                            </div>
                        </div>
                        <div id="admissionRatio"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Orders Value</h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown2" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown2"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a></div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells-2">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img
                                    src="{{ asset('assets/images/dashboard-3/icon/shopping1.png') }}" alt="icon"></div>
                            <div class="flex-grow-1">
                                <div class="d-flex align-items-center gap-2">
                                    <h2>78,596</h2>
                                    <div class="d-flex total-icon">
                                        <p class="mb-0 up-arrow bg-light-danger"><i
                                                class="fa fa-arrow-down text-danger"></i></p><span
                                            class="f-w-500 font-danger">- 10.02%</span>
                                    </div>
                                </div>
                                <p class="text-truncate">Compared to Aug 2024</p>
                            </div>
                        </div>
                        <div id="order-value"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Daily Orders</h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown3" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i
                                        class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown3"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells-3">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/icon/sent1.png') }}"
                                    alt="icon"></div>
                            <div class="flex-grow-1">
                                <div class="d-flex align-items-center gap-2">
                                    <h2>95,789</h2>
                                    <div class="d-flex total-icon">
                                        <p class="mb-0 up-arrow bg-light-success"><i
                                                class="fa fa-arrow-up text-success"></i></p><span
                                            class="f-w-500 font-success">+ 13.23%</span>
                                    </div>
                                </div>
                                <p class="text-truncate">Compared to may 2024</p>
                            </div>
                        </div>
                        <div id="daily-value"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top daily-revenue-card">
                            <h4>Daily Revenue</h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown4" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i
                                        class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown4"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pb-0 total-sells-4">
                        <div class="d-flex align-items-center gap-3">
                            <div class="flex-shrink-0"><img
                                    src="{{ asset('assets/images/dashboard-3/icon/revenue1.png') }}" alt="icon">
                            </div>
                            <div class="flex-grow-1">
                                <div class="d-flex align-items-center gap-2">
                                    <h2>41,954</h2>
                                    <div class="d-flex total-icon">
                                        <p class="mb-0 up-arrow bg-light-danger"><i
                                                class="fa fa-arrow-down text-danger"></i></p><span
                                            class="f-w-500 font-danger">- 17.06%</span>
                                    </div>
                                </div>
                                <p class="text-truncate">Compared to july 2024</p>
                            </div>
                        </div>
                        <div id="daily-revenue"></div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-7 col-xl-8 col-sm-12">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top">
                            <h4>Recent Orders</h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown5" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i
                                        class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown5"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0 recent-orders px-0">
                        <div class="table-responsive theme-scrollbar">
                            <table class="table display" id="recent-orders" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </th>
                                        <th>Recent Orders</th>
                                        <th>Order Date</th>
                                        <th>QTY</th>
                                        <th>Customer</th>
                                        <th>Price </th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/1.png') }}"
                                                        alt=""></div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.checkout') }}">
                                                        <h6>Decorative Plants</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>20 Sep - 03.00AM</td>
                                        <td>QTY:12</td>
                                        <td class="customer-img">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/6.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1">
                                                    <h6>Leonie Green </h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p>$637.30</p>
                                        </td>
                                        <td>
                                            <div class="status-box">
                                                <div class="btn background-light-success font-success f-w-500">Succeed
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/2.png') }}"
                                                        alt=""></div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.checkout') }}">
                                                        <h6>Sticky Calender</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>12 Mar - 08.12AM</td>
                                        <td>QTY:14</td>
                                        <td class="customer-img">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/8.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1">
                                                    <h6>Peter White</h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p>$637.30</p>
                                        </td>
                                        <td>
                                            <div class="status-box">
                                                <div class="btn background-light-warning font-warning f-w-500">Waiting
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/3.png') }}"
                                                        alt=""></div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.checkout') }}">
                                                        <h6>Crystal Mug</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>Feb 15 - 10.00AM</td>
                                        <td>QTY:19</td>
                                        <td class="customer-img">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/7.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1">
                                                    <h6>Ruby Yang </h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p>$637.30</p>
                                        </td>
                                        <td>
                                            <div class="status-box">
                                                <div class="btn background-light-success font-success f-w-500">Succeed
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/4.png') }}"
                                                        alt=""></div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.checkout') }}">
                                                        <h6>Motion Table Lamp</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>Jun 10 - 12.30AM</td>
                                        <td>QTY:17</td>
                                        <td class="customer-img">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/8.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1">
                                                    <h6>Visha Long</h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p>$637.30</p>
                                        </td>
                                        <td>
                                            <div class="status-box">
                                                <div class="btn background-light-danger font-danger f-w-500">Canceled</div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/2.png') }}"
                                                        alt=""></div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.checkout') }}">
                                                        <h6>Sticky Calender</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>12 Mar - 08.12AM</td>
                                        <td>QTY:14</td>
                                        <td class="customer-img">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/8.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1">
                                                    <h6>Peter White</h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p>$637.30</p>
                                        </td>
                                        <td>
                                            <div class="status-box">
                                                <div class="btn background-light-warning font-warning f-w-500">Waiting
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/3.png') }}"
                                                        alt=""></div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.checkout') }}">
                                                        <h6>Crystal Mug</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>Feb 15 - 10.00AM</td>
                                        <td>QTY:19</td>
                                        <td class="customer-img">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/7.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1">
                                                    <h6>Ruby Yang </h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p>$637.30</p>
                                        </td>
                                        <td>
                                            <div class="status-box">
                                                <div class="btn background-light-success font-success f-w-500">Succeed
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/4.png') }}"
                                                        alt=""></div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.checkout') }}">
                                                        <h6>Motion Table Lamp</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>Jun 10 - 12.30AM</td>
                                        <td>QTY:17</td>
                                        <td class="customer-img">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/8.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1">
                                                    <h6>Visha Long</h6>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p>$637.30</p>
                                        </td>
                                        <td>
                                            <div class="status-box">
                                                <div class="btn background-light-danger font-danger f-w-500">Canceled</div>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-5 col-xl-4 col-lg-7 col-sm-12">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top">
                            <h4>Sales Overview</h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown6" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i
                                        class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown6"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0">
                        <div id="salse-overview"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-5 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top">
                            <h4>Recent Customers</h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown7" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i
                                        class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown7"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0">
                        <ul class="recent-customers">
                            <li class="d-flex align-items-center gap-2">
                                <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/user/1.png') }}"
                                        alt=""></div>
                                <div class="flex-grow-1"><a href="{{ route('admin.cart') }}">
                                        <h5>Junsung Park</h5>
                                    </a>
                                    <p class="text-truncate">ID #32449<span class="text-success">Paid</span></p>
                                </div>
                                <div class="active-status active-online"></div>
                                <div class="recent-text">
                                    <h5>$8282.13</h5>
                                    <p>50 min ago</p>
                                </div>
                            </li>
                            <li class="d-flex align-items-center gap-2">
                                <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/user/2.png') }}"
                                        alt=""></div>
                                <div class="flex-grow-1"><a href="{{ route('admin.cart') }}">
                                        <h5>Yongjae Choi</h5>
                                    </a>
                                    <p class="text-truncate">ID #95460<span class="text-danger">Pending</span></p>
                                </div>
                                <div class="active-status active-online"></div>
                                <div class="recent-text">
                                    <h5>$9546.84 </h5>
                                    <p>34 min ago</p>
                                </div>
                            </li>
                            <li class="d-flex align-items-center gap-2">
                                <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/user/3.png') }}"
                                        alt=""></div>
                                <div class="flex-grow-1"><a href="{{ route('admin.cart') }}">
                                        <h5>Seonil Jang</h5>
                                    </a>
                                    <p class="text-truncate">ID #95468<span class="text-success">Paid</span></p>
                                </div>
                                <div class="active-status active-online"></div>
                                <div class="recent-text">
                                    <h5>$2354.16</h5>
                                    <p>30 min ago</p>
                                </div>
                            </li>
                            <li class="d-flex align-items-center gap-2">
                                <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/user/4.png') }}"
                                        alt=""></div>
                                <div class="flex-grow-1"><a href="{{ route('admin.cart') }}">
                                        <h5>Joohee Min</h5>
                                    </a>
                                    <p class="text-truncate">ID #95462<span class="text-danger"> Pending</span></p>
                                </div>
                                <div class="active-status active-online"></div>
                                <div class="recent-text">
                                    <h5>$3254.35</h5>
                                    <p>25 min ago</p>
                                </div>
                            </li>
                            <li class="d-flex align-items-center gap-2">
                                <div class="flex-shrink-0"><img src="{{ asset('assets/images/dashboard-3/user/5.png') }}"
                                        alt=""></div>
                                <div class="flex-grow-1"><a href="{{ route('admin.cart') }}">
                                        <h5>Soojung Kin</h5>
                                    </a>
                                    <p class="text-truncate">ID #34586<span class="text-success">Paid</span></p>
                                </div>
                                <div class="active-status active-online"></div>
                                <div class="recent-text">
                                    <h5>$3654.32</h5>
                                    <p>23 min ago</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-5 col-sm-6">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top">
                            <h4>Revenue By Category</h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown8" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i
                                        class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown8"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body revenue-category">
                        <div class="theme-scrollbar" id="pie-chart"></div>
                        <div class="donut-legend" id="legend"></div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-7 col-sm-12">
                <div class="card overflow-hidden">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top">
                            <h4>User by Continent</h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown9" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i
                                        class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown9"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body user-continent pb-0">
                        <div class="user-map-menu d-flex align-items-center gap-5">
                            <div class="user-items">
                                <h5>1,506<span>items</span></h5>
                                <div class="progress">
                                    <div class="progress-bar bg-primary" role="progressbar" style="width: 25%"
                                        aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    <div class="progress-bar bg-secondary" role="progressbar" style="width: 25%"
                                        aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    <div class="progress-bar bg-warning" role="progressbar" style="width: 25%"
                                        aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    <div class="progress-bar bg-tertiary" role="progressbar" style="width: 25%"
                                        aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                            </div>
                            <div class="map-items">
                                <ul class="d-flex align-items-center gap-3">
                                    <li>
                                        <h5><span class="bg-primary"></span>Keyboard</h5>
                                        <p class="mb-0">651</p>
                                    </li>
                                    <li>
                                        <h5><span class="bg-secondary"></span>Laptops</h5>
                                        <p class="mb-0">345</p>
                                    </li>
                                    <li>
                                        <h5><span class="bg-warning"></span>Desktop</h5>
                                        <p class="mb-0">654</p>
                                    </li>
                                    <li>
                                        <h5><span class="bg-tertiary"></span>Mouse</h5>
                                        <p class="mb-0">954</p>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="contries-sale d-flex gap-4">
                            <div class="map-value">
                                <h5>All Over Contries's Sale</h5>
                                <ul>
                                    <li>
                                        <div class="d-flex gap-2">
                                            <div class="flex-shrink-0">
                                                <svg>
                                                    <use class="fill-primary"
                                                        href="{{ asset('assets/svg/icon-sprite.svg#map-loaction') }}">
                                                    </use>
                                                </svg>
                                            </div>
                                            <div class="flex-grow-1">
                                                <h6>United States</h6>
                                            </div><span>53.23%</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="d-flex gap-2">
                                            <div class="flex-shrink-0">
                                                <svg>
                                                    <use class="fill-secondary"
                                                        href="{{ asset('assets/svg/icon-sprite.svg#map-loaction') }}">
                                                    </use>
                                                </svg>
                                            </div>
                                            <div class="flex-grow-1">
                                                <h6>Romania</h6>
                                            </div><span>31.85%</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="d-flex gap-2">
                                            <div class="flex-shrink-0">
                                                <svg>
                                                    <use class="fill-warning"
                                                        href="{{ asset('assets/svg/icon-sprite.svg#map-loaction') }}">
                                                    </use>
                                                </svg>
                                            </div>
                                            <div class="flex-grow-1">
                                                <h6>Austalia</h6>
                                            </div><span>12.98%</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="d-flex gap-2">
                                            <div class="flex-shrink-0">
                                                <svg>
                                                    <use class="fill-tertiary"
                                                        href="{{ asset('assets/svg/icon-sprite.svg#map-loaction') }}">
                                                    </use>
                                                </svg>
                                            </div>
                                            <div class="flex-grow-1">
                                                <h6>Germany</h6>
                                            </div><span>45.23%</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="d-flex gap-2">
                                            <div class="flex-shrink-0">
                                                <svg>
                                                    <use class="fill-success"
                                                        href="{{ asset('assets/svg/icon-sprite.svg#map-loaction') }}">
                                                    </use>
                                                </svg>
                                            </div>
                                            <div class="flex-grow-1">
                                                <h6>Africa</h6>
                                            </div><span>23.15%</span>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="d-flex gap-2">
                                            <div class="flex-shrink-0">
                                                <svg>
                                                    <use class="fill-danger"
                                                        href="{{ asset('assets/svg/icon-sprite.svg#map-loaction') }}">
                                                    </use>
                                                </svg>
                                            </div>
                                            <div class="flex-grow-1">
                                                <h6>Europe</h6>
                                            </div><span>95.75%</span>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <div class="map">
                                <div class="jvector-map-height" id="world-map2"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-12">
                <div class="card">
                    <div class="card-body product-slider">
                        <div class="row align-items-center">
                            <div class="col-sm-6">
                                <div class="product-page-main p-0">
                                    <div class="row">
                                        <div class="col-3 product-thumbnail">
                                            <div class="pro-slide-right">
                                                <div class="mt-4">
                                                    <div class="slide-box"><img class="img-fluid"
                                                            src="{{ asset('assets/images/dashboard-3/slider/1.png') }}"
                                                            alt=""></div>
                                                </div>
                                                <div>
                                                    <div class="slide-box"><img class="img-fluid"
                                                            src="{{ asset('assets/images/dashboard-3/slider/2.png') }}"
                                                            alt=""></div>
                                                </div>
                                                <div>
                                                    <div class="slide-box"><img class="img-fluid"
                                                            src="{{ asset('assets/images/dashboard-3/slider/3.png') }}"
                                                            alt=""></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-9 px-0 product-main">
                                            <div class="pro-slide-single">
                                                <div> <img class="img-fluid"
                                                        src="{{ asset('assets/images/dashboard-3/slider/4.png') }}"
                                                        alt="">
                                                </div>
                                                <div><img class="img-fluid"
                                                        src="{{ asset('assets/images/dashboard-3/slider/5.png') }}"
                                                        alt="">
                                                </div>
                                                <div><img class="img-fluid"
                                                        src="{{ asset('assets/images/dashboard-3/slider/6.png') }}"
                                                        alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="product-details my-4"><a href="{{ route('admin.product_page') }}">
                                        <h4 class="text-truncate">Women’s Fit and Flare Knee length one Piece Dress </h4>
                                    </a>
                                    <h3 class="font-primary">$126</h3>
                                    <h5>Select size:</h5>
                                    <ul class="product-size">
                                        <li>S </li>
                                        <li>M </li>
                                        <li>L </li>
                                        <li>XL</li>
                                    </ul>
                                    <h5>Colour:</h5>
                                    <ul class="product-color">
                                        <li class="border-primary"><span class="bg-primary"> <i
                                                    class="icon-check"></i></span></li>
                                        <li class="border-secondary"><span class="bg-secondary"> </span></li>
                                        <li class="border-warning"><span class="bg-warning"> </span></li>
                                        <li class="border-tertiary"><span class="bg-tertiary"></span></li>
                                    </ul>
                                    <div class="discount-box">
                                        <h6>Special Discount </h6>
                                    </div>
                                    <h3 class="text-truncate">Deal of the Day From <span class="font-secondary">$48
                                        </span></h3>
                                    <div class="countdown" id="clock-arrival" data-hours="1" data-minutes="2"
                                        data-seconds="3">
                                        <ul>
                                            <li><span class="days time"></span><span class="title">Days</span></li>
                                            <li><span class="hours time"></span><span class="title">Hours</span></li>
                                            <li class="px-3"><span class="minutes time"></span><span
                                                    class="title">Min</span></li>
                                            <li class="px-3"><span class="seconds time"></span><span
                                                    class="title">Sec</span></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 col-lg-12">
                <div class="card">
                    <div class="card-header card-no-border pb-0">
                        <div class="header-top top-sellers">
                            <h4 class="text-truncate">Top seller of the month</h4>
                            <div class="dropdown icon-dropdown">
                                <button class="btn dropdown-toggle" id="userdropdown10" type="button"
                                    data-bs-toggle="dropdown" aria-expanded="false"><i
                                        class="icon-more-alt"></i></button>
                                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="userdropdown10"><a
                                        class="dropdown-item" href="#">Weekly</a><a class="dropdown-item"
                                        href="#">Monthly</a><a class="dropdown-item" href="#">Yearly</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0 seller-month px-0">
                        <div class="table-responsive theme-scrollbar">
                            <table class="table display" id="seller-month" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </th>
                                        <th>Seller Name</th>
                                        <th>Brand Name</th>
                                        <th>Product</th>
                                        <th>Sold</th>
                                        <th>Price</th>
                                        <th>Earnings</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/9.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.product_page') }}">
                                                        <h6>Gary Waters</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>Adidas</td>
                                        <td>Clothes</td>
                                        <td>650 </td>
                                        <td>
                                            <p>$37.50</p>
                                        </td>
                                        <td>$24375</td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/10.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.product_page') }}">
                                                        <h6>Edwin Hogan</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>Nike</td>
                                        <td>Shoes</td>
                                        <td>956</td>
                                        <td>
                                            <p>$24.75</p>
                                        </td>
                                        <td>$23661</td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/11.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.product_page') }}">
                                                        <h6>Aaron Hogan</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>Sony</td>
                                        <td>Electronics</td>
                                        <td>348</td>
                                        <td>
                                            <p>$184.50</p>
                                        </td>
                                        <td>$64206</td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="">
                                                <label class="form-check-label"></label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="flex-shrink-0"><img
                                                        src="{{ asset('assets/images/dashboard-3/user/12.png') }}"
                                                        alt="">
                                                </div>
                                                <div class="flex-grow-1"><a href="{{ route('admin.product_page') }}">
                                                        <h6>Ralph Waters</h6>
                                                    </a></div>
                                            </div>
                                        </td>
                                        <td>i Phone</td>
                                        <td>Mobile</td>
                                        <td>100</td>
                                        <td>
                                            <p>$150.25</p>
                                        </td>
                                        <td>$15025</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/chart/morris-chart/raphael.js') }}"></script>
    <script src="{{ asset('assets/js/chart/morris-chart/morris.js') }}"></script>
    <script src="{{ asset('assets/js/chart/morris-chart/prettify.min.js') }}"></script>
    <script src="{{ asset('assets/js/chart/apex-chart/apex-chart.js') }}"></script>
    <script src="{{ asset('assets/js/chart/apex-chart/stock-prices.js') }}"></script>
    <script src="{{ asset('assets/js/chart/apex-chart/moment.min.js') }}"></script>
    <script src="{{ asset('assets/js/chart/echart/pie-chart/facePrint.js') }}"></script>
    <script src="{{ asset('assets/js/chart/echart/pie-chart/testHelper.js') }}"></script>
    <script src="{{ asset('assets/js/chart/echart/pie-chart/custom-transition-texture.js') }}"></script>
    <script src="{{ asset('assets/js/chart/echart/data/symbols.js') }}"></script>
    <script src="{{ asset('assets/js/slick/slick-theme.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/jquery-jvectormap-2.0.2.min.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-world-mill-en.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-us-aea-en.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-uk-mill-en.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-au-mill.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-chicago-mill-en.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-in-mill.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map/jquery-jvectormap-asia-mill.js') }}"></script>
    <!-- calendar js-->
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatable.custom1.js') }}"></script>
    <script src="{{ asset('assets/js/datepicker/date-picker/datepicker.js') }}"></script>
    <script src="{{ asset('assets/js/datepicker/date-picker/datepicker.en.js') }}"></script>
    <script src="{{ asset('assets/js/datepicker/date-picker/datepicker.custom.js') }}"></script>
    <script src="{{ asset('assets/js/rating/jquery.barrating.js') }}"></script>
    <script src="{{ asset('assets/js/rating/rating-script.js') }}"></script>
    <script src="{{ asset('assets/js/owlcarousel/owl.carousel.js') }}"></script>
    <script src="{{ asset('assets/js/vector-map/map-vector.js') }}"></script>
    <script src="{{ asset('assets/js/countdown.js') }}"></script>
    <script src="{{ asset('assets/js/dashboard/dashboard_3.js') }}"></script>
    <script src="{{ asset('assets/js/ecommerce.js') }}"></script>
@endsection
