@extends('layouts.master')

@section('title', 'JS-Grid Tables')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/jsgrid.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/animate.css') }}">
@endsection

@section('breadcrumb')
    <div class="header-logo-wrapper col-auto">
        <div class="logo-wrapper"><a href="{{ route('admin.dashboard') }}"><img class="img-fluid for-light"
                    src="{{ asset('assets/images/logo/logo.png') }}" alt="" /><img class="img-fluid for-dark"
                    src="{{ asset('assets/images/logo/logo_light.png') }}" alt="" /></a></div>
    </div>
    <div class="col-4 col-xl-4 page-title">
        <h4 class="f-w-700">JS Grid Tables</h4>
        <nav>
            <ol class="breadcrumb justify-content-sm-start align-items-center mb-0">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"> <i data-feather="home"> </i></a></li>
                <li class="breadcrumb-item f-w-400">Tables</li>
                <li class="breadcrumb-item f-w-400 active">JS Grid Tables</li>
            </ol>
        </nav>
    </div>
@endsection

@section('main_content')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0 card-no-border">
                        <h4 class="mb-2">Basic Scenario</h4><span>Grid with filtering, editing, inserting, deleting,
                            sorting and paging. Data provided by controller.</span>
                    </div>
                    <div class="card-body">
                        <div class="basic_table" id="basicScenario"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0 card-no-border">
                        <h4 class="mb-2">Sorting Scenario</h4><span>Sorting can be done not only with column header
                            interaction, but also with sort method.</span>
                    </div>
                    <div class="card-body">
                        <div class="sort-panel mb-3">
                            <label>Sorting Field:
                                <select class="btn btn-primary dropdown-toggle btn-md pe-5" id="sortingField">
                                    <option>Id</option>
                                    <option>Product</option>
                                    <option>Order Id</option>
                                    <option>Price</option>
                                    <option>Quantity</option>
                                    <option>Shipped</option>
                                    <option>Total</option>
                                </select>
                            </label>
                            <div class="d-inline">
                                <button class="btn btn-md btn-secondary" id="sort" type="button">Sort</button>
                            </div>
                        </div>
                        <div class="js-shorting" id="sorting-table"></div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0 card-no-border">
                        <h4 class="mb-2">Batch Delete</h4><span>Cell content of every column can be customized with
                            itemTemplate, headerTemplate, filterTemplate and insertTemplate functions specified in field
                            config. This example shows how to implement batch deleting with custom field for selecting
                            items.</span>
                    </div>
                    <div class="card-body">
                        <div id="batchDelete"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid Ends-->
@endsection

@section('scripts')
    <!-- calendar js-->
    <script src="{{ asset('assets/js/jsgrid/jsgrid.min.js') }}"></script>
    <script src="{{ asset('assets/js/jsgrid/griddata.js') }}"></script>
    <script src="{{ asset('assets/js/jsgrid/jsgrid.js') }}"></script>
@endsection
