<?php

namespace App\Http\Controllers\Admin;


use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Admin\LocationController;
use App\Http\Controllers\Admin\ClaimController;
use App\Http\Controllers\Admin\PolicyController;
use App\Http\Controllers\Admin\PolicyAjaxController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\Admin\AppointmentController;
use App\Http\Controllers\Admin\CustomerMapController;


use App\Http\Controllers\Admin\DashboardController;



Route::get('/customers/select2', [CustomerController::class, 'select2'])->name('customers.select2');
Route::get('/policies/by-customer/{customer_id}', [PolicyController::class, 'getByCustomer'])->name('policies.byCustomer');
Route::get('/policies/details/{id}', [PolicyController::class, 'details'])->name('policies.details');
Route::post('/claims/store', [ClaimController::class, 'store'])->name('claims.store');
Route::get('/customers/data', [CustomerController::class, 'getData'])->name('customers.data');

Route::resource('customers', CustomerController::class);

Route::get('/customer/create', [CustomerController::class, 'showForm']);

Route::get('/state-customer-counts', [CustomerMapController::class, 'getCityCustomerCounts']);

Auth::routes(['register' => false, 'verify' => false]);


Route::get('/', function () {
    return redirect()->route('login');

});


Auth::routes();


Route::prefix('admin')->name('admin.')->group(function () {


    Route::get('/dashboard/notification-stats', [DashboardController::class, 'notificationStats'])->name('dashboard.notification-stats');
    Route::get('/notifications/channel-data', [DashboardController::class, 'channelData'])->name('notifications.channel-data');
    Route::get('/notifications/export', [DashboardController::class, 'export'])->name('notifications.export');


    Route::get('dashboard/notification-stats', [DashboardController::class, 'getNotificationStats'])->name('dashboard.notification-stats');

    // routes/web.php
Route::get('/admin/dashboard/channel/{channel}', [DashboardController::class, 'channelBreakdown']);

Route::get('/admin/dashboard/channel/{channel}/export', [DashboardController::class, 'exportChannel']);

    Route::get('admin/claims/create', [ClaimController::class, 'create'])->name('claims.create');

    Route::post('admin/claims', [ClaimController::class, 'store'])->name('claims.store');

    Route::get('policies/{id}', [PolicyController::class, 'show']);

    Route::get('/admin/policies/{id}', [ClaimController::class, 'getPolicy'])->name('admin.policies.show');

    // Claim form display
    Route::get('/claims/create', [ClaimController::class, 'create'])->name('claims.create');

    // Claim submission
    Route::post('/claims', [ClaimController::class, 'store'])->name('claims.store');

    //Fetch Countries, Regions, Cities and Woreda
    Route::get('/get-regions/{country}', [LocationController::class, 'getRegions'])->name('getRegions');
    Route::get('/get-cities/{region}', [LocationController::class, 'getCities'])->name('getCities');
    Route::get('/get-woredas/{city}', [LocationController::class, 'getWoredas'])->name('getWoredas');
});

Route::group(['middleware' => ['auth'], 'as' => 'admin.', 'prefix' => 'admin'], function () {



    Route::get('/api/appointments', [AppointmentController::class, 'calendarData']);

    Route::get('appointments/{id}', [AppointmentController::class, 'show']);
     Route::get('dashboard/stats', [DashboardController::class, 'getStats'])->name('dashboard.stats');


    Route::get('/admin/invoice-summary', [InvoiceController::class, 'summary'])->name('invoice-summary');


    Route::get('customers', [CustomerController::class, 'index'])->name('customers.index');


    Route::get('claims', [ClaimController::class, 'index'])->name('claims.index');

    Route::get('claims-data', [ClaimController::class, 'getClaimsData'])->name('claims.data');







    // under development
    Route::view('/under-development', 'under-development')->name('under-development');








    // Dashboard
    Route::get('dashboard', [DashboardController::class, 'index'])->name('default_dashboard');

    Route::post('/admin/notifications/send', [NotificationController::class, 'send'])->name('notifications.send');




    Route::view('default-dashboard', 'dashboards.default_dashboard')->name('dashboard');



    Route::get('notifications', [NotificationController::class, 'index'])->name('notifications.index');


    Route::get('/notifications/{id}', [NotificationController::class, 'show'])->name('notifications.show');


    Route::get('/notifications/view/{id}', [NotificationController::class, 'show_id'])->name('.notifications.show_id');

     Route::post('/notifications/generate-ivr', [NotificationController::class, 'generateIVRAudio'])->name('admin.notifications.generateIVR');

     Route::get('/notification-jobs/recent', [DashboardController::class, 'recentJobs']);

});
