<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClaimNotificationRegistration extends Model
{
    protected $fillable = [
        'customer_id',
        'policy_id',
        'claim_id',
        'cob',
        'registration_date',
        'customer_mobile',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function policy()
    {
        return $this->belongsTo(Policy::class);
    }

    public function claim()
    {
        return $this->belongsTo(Claim::class);
    }
}
