<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

use Illuminate\Support\Facades\Log;


class SmsService
{
    public function sendSms($to, $message)
    {
        $response = Http::withHeaders([
            'Authorization' => 'Bearer ' . env('SMS_API_TOKEN'),
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
        ])->post('https://api.geezsms.com/api/v1/send', [ // Replace with real URL
            'to' => $to,
            'message' => $message,
            'sender_id' => 'YourSenderID', // optional, depends on your provider
        ]);

        Log::info('SMS API response: ', [
            'status' => $response->status(),
            'body' => $response->body(),
        ]);

        if ($response->successful()) {
            return [
                'status' => 'success',
                'data' => $response->json(),
            ];
        } else {
            return [
                'status' => 'error',
                'error' => $response->body(),
            ];
        }
    }
}



