<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('system_settings', function (Blueprint $table) {
            // Primary Key
            $table->increments('id'); // int(10) UNSIGNED NOT NULL
            
            // Site Configuration
            $table->string('site_name', 255)->default('Insurance CRM');
            $table->string('site_logo', 255)->nullable();
            
            // Localization Settings
            $table->string('timezone', 50)->default('UTC');
            $table->string('date_format', 50)->default('Y-m-d');
            $table->string('time_format', 50)->default('H:i:s');
            $table->string('currency', 10)->default('USD');
            $table->string('default_language', 10)->default('en');
            
            // Security Settings
            $table->integer('login_attempt_limit')->default(5);
            $table->integer('lockout_duration')->default(15);
            $table->integer('session_timeout')->default(1800);
            $table->boolean('captcha_enabled')->default(true);
            
            // System Operations
            $table->boolean('maintenance_mode')->default(false);
            $table->integer('api_rate_limit')->default(100);
            
            // Verification Requirements
            $table->boolean('email_verification_required')->default(true);
            $table->boolean('phone_verification_required')->default(false);
            
            // Timestamps
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });

        // Explicit database configuration
        Schema::table('system_settings', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('system_settings');
    }
};