<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('claims', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id'); // bigint(20) UNSIGNED NOT NULL

            // Foreign Keys
            $table->foreignId('policy_id')->constrained(); // bigint(20) UNSIGNED
            $table->foreignId('user_id')->constrained(); // bigint(20) UNSIGNED

            // Claim Details
            $table->string('claim_number', 50)->unique();
            $table->string('claim_type', 100);
            $table->decimal('claim_amount', 12, 2);
            $table->text('description');
            $table->decimal('estimated_loss', 15, 2);
            $table->decimal('fraud_score', 5, 2)->nullable();

            // Status Tracking
            $table->enum('claim_status', ['pending','approved','rejected','fraud'])
                  ->default('pending');

            // Timestamps
            $table->timestamp('submitted_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->timestamp('approved_at')->nullable();

            // Processor
            $table->foreignId('processed_by')
                  ->nullable()
                  ->constrained('users')
                  ->onDelete('set null');
        });

        // Explicit database configuration
        Schema::table('claims', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('claims');
    }
};