<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('ivr_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('notification_id')->constrained()->onDelete('cascade');
            $table->string('phone_number');
            $table->text('ivr_script')->nullable(); // The script or recording played
            $table->enum('call_status', ['initiated', 'connected', 'failed', 'completed']);
            $table->integer('duration')->nullable(); // in seconds
            $table->json('response_details')->nullable(); // e.g., DTMF inputs or call metadata
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('ivr_logs');
    }
};
