<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            // Primary Key
            $table->bigIncrements('id');

            // Foreign Keys
            $table->foreignId('user_id')->constrained();
            $table->foreignId('policy_id')->constrained();

            // Payment Details
            $table->decimal('amount', 15, 2);
            $table->string('currency', 3)->default('USD');
            $table->enum('payment_method', [
                'credit_card',
                'bank_transfer',
                'mobile_money',
                'crypto'
            ]);

            // Status & Reference
            $table->enum('status', [
                'pending',
                'completed',
                'failed',
                'reversed'
            ])->default('pending');
            
            $table->string('transaction_ref', 100)->unique();

            // Timestamps
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrent()->useCurrentOnUpdate();
        });

        // Database-specific configuration
        Schema::table('payments', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
        });
    }

    public function down()
    {
        Schema::dropIfExists('payments');
    }
};