<ul class="nav nav-tabs mb-3" role="tablist">
  <?php
      $tabs = [
          'tabCustomer' => 'Customer',
          'tabClaims' => 'Claims',
          'tabPolicies' => 'Policies',
          'tabPayments' => 'Claim Payments',
          'tabSurvey' => 'Surveys',
          'tabGarage' => 'Garage Discharges',
          'tabWorkOrder' => 'Work Orders',
      ];
  ?>

  <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <li class="nav-item">
      <a class="nav-link <?php if($loop->first): ?> active <?php endif; ?>" data-bs-toggle="tab" href="#<?php echo e($id); ?>"><?php echo e($label); ?></a>
    </li>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</ul>

<div class="tab-content border rounded shadow-sm p-3 bg-light">
  
  <div class="tab-pane fade show active" id="tabCustomer" role="tabpanel">
    <table class="table table-bordered table-sm mb-0">
    <tbody>
  <tr><th>Name</th><td><?php echo e($notification->customer->full_name ?? 'N/A'); ?></td></tr>
  <tr><th>Email</th><td><?php echo e($notification->customer->email ?? '—'); ?></td></tr>
  <tr><th>Phone</th><td><?php echo e($notification->customer->phone_number ?? '—'); ?></td></tr>
  <tr><th>Preferred Language</th><td><?php echo e(strtoupper($notification->customer->preferred_language ?? 'EN')); ?></td></tr>

  <?php
      $prefs = $notification->customer->notificationPreference;
  ?>

  <tr>
    <th>Notification Channels</th>
    <td>
      <div class="form-check form-check-inline">
        <input class="form-check-input" type="checkbox" disabled checked>
        <label class="form-check-label">SMS</label>
      </div>
      <div class="form-check form-check-inline">
        <input class="form-check-input" type="checkbox" disabled <?php echo e($prefs?->via_email ? 'checked' : ''); ?>>
        <label class="form-check-label">Email</label>
      </div>
      <div class="form-check form-check-inline">
        <input class="form-check-input" type="checkbox" disabled checked >
        <label class="form-check-label">IVR</label>
      </div>
    </td>
  </tr>

  <tr>
    <th>Preferred Notification Language</th>
    <td><?php echo e(strtoupper($prefs?->language ?? 'EN')); ?></td>
  </tr>
</tbody>

    </table>
  </div>

  
  <div class="tab-pane fade" id="tabClaims">
    <?php $__empty_1 = true; $__currentLoopData = $notification->claims ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $claim): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Claim #</th>
            <th>Status</th>
            <th>Created At</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><?php echo e($claim->claim_number); ?></td>
            <td><span class="badge bg-info"><?php echo e(ucfirst($claim->status)); ?></span></td>
            <td><?php echo e(\Carbon\Carbon::parse($claim->created_at)->format('F j, Y')); ?></td>
          </tr>
        </tbody>
      </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
      <p class="text-muted">No claims found.</p>
    <?php endif; ?>
  </div>

  
  <div class="tab-pane fade" id="tabPolicies">
    <?php $__empty_1 = true; $__currentLoopData = $notification->policies ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Policy #</th>
            <th>Coverage</th>
            <th>Expires</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><?php echo e($policy->policy_number); ?></td>
            <td><?php echo e($policy->coverage_type ?? '-'); ?></td>
            <td><?php echo e(\Carbon\Carbon::parse($policy->expiry_date)->format('F j, Y')); ?></td>
          </tr>
        </tbody>
      </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
      <p class="text-muted">No policies found.</p>
    <?php endif; ?>
  </div>

  
  <div class="tab-pane fade" id="tabPayments">
    <?php $__empty_1 = true; $__currentLoopData = $notification->claimPayments ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Amount</th>
            <th>Paid At</th>
            <th>Method</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><?php echo e(number_format($payment->amount, 2)); ?></td>
            <td><?php echo e(\Carbon\Carbon::parse($payment->paid_at)->format('F j, Y')); ?></td>
            <td><?php echo e($payment->method ?? '-'); ?></td>
          </tr>
        </tbody>
      </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
      <p class="text-muted">No claim payments found.</p>
    <?php endif; ?>
  </div>

  
  <div class="tab-pane fade" id="tabSurvey">
    <?php $__empty_1 = true; $__currentLoopData = $notification->surveyStatuses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $survey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Status</th>
            <th>Created At</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><span class="badge bg-success"><?php echo e($survey->survey_status); ?></span></td>
            <td><?php echo e(\Carbon\Carbon::parse($survey->created_at)->format('F j, Y')); ?></td>
          </tr>
        </tbody>
      </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
      <p class="text-muted">No survey records found.</p>
    <?php endif; ?>
  </div>

  
  <div class="tab-pane fade" id="tabGarage">
    <?php $__empty_1 = true; $__currentLoopData = $notification->garageDischarges ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $garage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Garage</th>
            <th>Discharged At</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><?php echo e($garage->garage_name); ?></td>
            <td><?php echo e(\Carbon\Carbon::parse($garage->discharge_date)->format('F j, Y')); ?></td>
          </tr>
        </tbody>
      </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
      <p class="text-muted">No garage discharge data.</p>
    <?php endif; ?>
  </div>

  
  <div class="tab-pane fade" id="tabWorkOrder">
    <?php $__empty_1 = true; $__currentLoopData = $notification->workOrders ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $work): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
      <table class="table table-striped table-sm">
        <thead>
          <tr>
            <th>Description</th>
            <th>Created At</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td><?php echo e($work->description); ?></td>
            <td><?php echo e(\Carbon\Carbon::parse($work->created_at)->format('F j, Y')); ?></td>
          </tr>
        </tbody>
      </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
      <p class="text-muted">No work orders found.</p>
    <?php endif; ?>
  </div>

</div>
<?php /**PATH E:\Addisalem.Hailu Files\xampp\htdocs\NISCIO_Notification_System\resources\views/admin/notifications/partials/modal-tabs.blade.php ENDPATH**/ ?>