<h5 class="modal-title mb-3">Notification Detail</h5>

<ul class="list-group mb-4">
    <li class="list-group-item"><strong>Title:</strong> <?php echo e($notif->title); ?></li>
    <li class="list-group-item"><strong>Message:</strong> <?php echo e($notif->message); ?></li>
    <li class="list-group-item"><strong>Channel:</strong>
        <span class="badge bg-<?php echo e($notif->channel === 'sms' ? 'success' : ($notif->channel === 'email' ? 'primary' : 'warning')); ?>">
            <?php echo e(strtoupper($notif->channel)); ?>

        </span>
    </li>
    <li class="list-group-item"><strong>Status:</strong>
        <span class="badge bg-<?php echo e($notif->status === 'sent' ? 'success' : ($notif->status === 'pending' ? 'info' : 'danger')); ?>">
            <?php echo e(ucfirst($notif->status)); ?>

        </span>
    </li>
    <li class="list-group-item"><strong>Scheduled:</strong>
        <?php echo e(optional($notif->scheduled_at)->format('F j, Y - H:i:s') ?? 'N/A'); ?>

    </li>
    <li class="list-group-item"><strong>Created At:</strong>
        <?php echo e(optional($notif->created_at)->format('F j, Y - H:i:s') ?? 'N/A'); ?>

    </li>
</ul>

<div class="mb-4">
    <h6 class="fw-bold">Customer Info</h6>
    <?php if($notif->customer): ?>
        <ul class="list-group">
            <li class="list-group-item"><strong>Name:</strong> <?php echo e($notif->customer->full_name); ?></li>
            <li class="list-group-item"><strong>Phone:</strong> <?php echo e($notif->customer->phone_number); ?></li>
            <li class="list-group-item"><strong>Email:</strong> <?php echo e($notif->customer->email ?? 'N/A'); ?></li>
            <li class="list-group-item"><strong>Language:</strong> <?php echo e(strtoupper($notif->customer->preferred_language ?? 'EN')); ?></li>
        </ul>
    <?php else: ?>
        <div class="alert alert-warning mt-2">Customer not found.</div>
    <?php endif; ?>
</div>

<?php
    $title = strtolower($notif->title);
?>

<?php if(str_contains($title, 'claim')): ?>
    <div class="alert alert-secondary"><strong>Claims Info:</strong> This notification is related to a registered claim.</div>
<?php endif; ?>

<?php if(str_contains($title, 'survey')): ?>
    <div class="alert alert-secondary"><strong>Survey:</strong> The related policy survey has been completed.</div>
<?php endif; ?>

<?php if(str_contains($title, 'work order')): ?>
    <div class="alert alert-secondary"><strong>Work Order:</strong> This refers to a work order assignment.</div>
<?php endif; ?>

<?php if(str_contains($title, 'garage')): ?>
    <div class="alert alert-secondary"><strong>Garage Discharge:</strong> The vehicle has been released from the garage.</div>
<?php endif; ?>

<?php if(str_contains($title, 'payment')): ?>
    <div class="alert alert-secondary"><strong>Payment:</strong> This refers to claim settlement or reimbursement.</div>
<?php endif; ?>

<?php /**PATH E:\Addisalem.Hailu Files\xampp\htdocs\NISCIO_Notification_System\resources\views/admin/notifications/partials/modal-content.blade.php ENDPATH**/ ?>